<?php
/**
 * This will display for all archive template blog
 * @since Blog Designer Pro 1.1
 */
get_header();
?>
<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">
        <?php
        do_action('bdp_before_archive_page');
        $theme = '';
        $bdp_settings = array();
        $archive_list = bdp_get_archive_list();
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        if (is_date() && in_array('date_template', $archive_list)) {
            $date_settings = bdp_get_date_template_settings();
            $allsettings = $date_settings->settings;
            if (is_serialized($allsettings)) {
                $bdp_settings = unserialize($allsettings);
            }
            $theme = apply_filters('bdp_filter_template', $bdp_settings['template_name']);
            $bdp_template_name_changed = get_option('bdp_template_name_changed', 1);
            if($bdp_template_name_changed == 1) {
                if($theme == 'classical') {
                   $theme = 'nicy';
                } elseif($theme == 'lightbreeze') {
                    $theme = 'sharpen';
                } elseif($theme == 'spektrum') {
                    $theme = 'hub';
                }
            } else {
                update_option('bdp_template_name_changed', 0);
            }
        } elseif (is_author() && in_array('author_template', $archive_list)) {
            $author_id = get_query_var('author');
            $bdp_settings = bdp_get_author_template_settings($author_id, $archive_list);
                if($bdp_settings) {
                $theme = $bdp_settings['template_name'];
                $bdp_template_name_changed = get_option('bdp_template_name_changed', 1);
                if($bdp_template_name_changed == 1) {
                    if($theme == 'classical') {
                       $theme = 'nicy';
                    } elseif($theme == 'lightbreeze') {
                        $theme = 'sharpen';
                    } elseif($theme == 'spektrum') {
                        $theme = 'hub';
                    }
                } else {
                    update_option('bdp_template_name_changed', 0);
                }
            }
        } else if (is_category() && in_array('category_template', $archive_list)) {
            $categories = get_category(get_query_var('cat'));
            $category_id = $categories->cat_ID;
            $bdp_settings = bdp_get_category_template_settings($category_id, $archive_list);
            if ($bdp_settings) {
                $theme = $bdp_settings['template_name'];
                $bdp_template_name_changed = get_option('bdp_template_name_changed', 1);
                if($bdp_template_name_changed == 1) {
                    if($theme == 'classical') {
                       $theme = 'nicy';
                    } elseif($theme == 'lightbreeze') {
                        $theme = 'sharpen';
                    } elseif($theme == 'spektrum') {
                        $theme = 'hub';
                    }
                } else {
                    update_option('bdp_template_name_changed', 0);
                }
            }
        } else if (is_tag() && in_array('tag_template', $archive_list)) {
            $tag_id = get_query_var('tag_id');
            $bdp_settings = bdp_get_tag_template_settings($tag_id, $archive_list);
            if ($bdp_settings) {
                $theme = $bdp_settings['template_name'];
                $bdp_template_name_changed = get_option('bdp_template_name_changed', 1);
                if($bdp_template_name_changed == 1) {
                    if($theme == 'classical') {
                       $theme = 'nicy';
                    } elseif($theme == 'lightbreeze') {
                        $theme = 'sharpen';
                    } elseif($theme == 'spektrum') {
                        $theme = 'hub';
                    }
                } else {
                    update_option('bdp_template_name_changed', 0);
                }
            }
        } else if (is_search() && in_array('search_template', $archive_list)) {
            $search_settings = bdp_get_search_template_settings();
            $allsettings = $search_settings->settings;
            if (is_serialized($allsettings)) {
                $bdp_settings = unserialize($allsettings);
            }
            $theme = apply_filters('bdp_filter_template', $bdp_settings['template_name']);
            $bdp_template_name_changed = get_option('bdp_template_name_changed', 1);
            if($bdp_template_name_changed == 1) {
                if($theme == 'classical') {
                   $theme = 'nicy';
                } elseif($theme == 'lightbreeze') {
                    $theme = 'sharpen';
                } elseif($theme == 'spektrum') {
                    $theme = 'hub';
                }
            } else {
                update_option('bdp_template_name_changed', 0);
            }
        }
        if (isset($bdp_settings['bdp_blog_order_by'])) {
            $orderby = $bdp_settings['bdp_blog_order_by'];
        }
        if (isset($bdp_settings['firstpost_unique_design']) && $bdp_settings['firstpost_unique_design'] != "") {
            $firstpost_unique_design = $bdp_settings['firstpost_unique_design'];
        } else {
            $firstpost_unique_design = 0;
        }
        $alter_class = '';
        $prev_year = '';
        $alter = 1;
        $alter_val = null;
        $main_container_class = (isset($bdp_settings['main_container_class']) && $bdp_settings['main_container_class'] != '') ? $bdp_settings['main_container_class'] : '';

        if ($theme == 'crayon_slider' || $theme == 'sunshiny_slider' || $theme == 'sallet_slider') {
            $unique_id = mt_rand();
        }
        ?>
        <div class="blog_template bdp_archive <?php echo $theme; ?>">
            <?php
            if($main_container_class != '') {
                echo '<div class="'. $main_container_class .'">';
            }
            if ($theme == "offer_blog") {
                echo '<div class="bdp_single_offer_blog">';
            }
            if ($theme == "winter") {
                echo '<div class="bdp_single_winter">';
            }
            if (is_author() && in_array('author_template', $archive_list)) {
                $display_author = isset($bdp_settings['display_author_data']) ? $bdp_settings['display_author_data'] : 0;
                $txtAuthorTitle = isset($bdp_settings['txtAuthorTitle']) ? $bdp_settings['txtAuthorTitle'] : '[author]';
                $display_author_biography = isset($bdp_settings['display_author_biography']) ? $bdp_settings['display_author_biography'] : '';
                if ($display_author == 1) {
                    ?>
                    <div class="author-avatar-div bdp_blog_template bdp-author-avatar">
                        <?php
                        if ($theme == "news") {
                            ?>
                            <div class="author_div bdp_blog_template">
                                <ul class="nav nav-tabs">
                                    <li class="active">
                                        <span class="ts-fab-tab-text"><?php _e('About Author', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div id="home" class="tab-pane fade in active">
                                        <?php
                                        do_action('bdp_author_archive_detail', $theme, $display_author_biography, $txtAuthorTitle, $bdp_settings);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        } else {
                            do_action('bdp_author_archive_detail', $theme, $display_author_biography, $txtAuthorTitle, $bdp_settings);
                        }
                        ?>
                    </div>
                    <?php
                }
            }
            if ($theme == 'timeline') {
                if (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'left_side') {
                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                        echo '<div class="timeline_bg_wrap left_side with_year"><div class="timeline_back clearfix">';
                    } else {
                        echo '<div class="timeline_bg_wrap left_side"><div class="timeline_back clearfix">';
                    }
                } elseif (isset($bdp_settings['bdp_timeline_layout']) && $bdp_settings['bdp_timeline_layout'] == 'right_side') {
                    if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] != '') {
                        echo '<div class="timeline_bg_wrap right_side with_year"><div class="timeline_back clearfix">';
                    } else {
                        echo '<div class="timeline_bg_wrap right_side"><div class="timeline_back clearfix">';
                    }
                } else {
                    if ($orderby == 'date' || $orderby == 'modified') {
                        echo '<div class="timeline_bg_wrap date_order"><div class="timeline_back clearfix">';
                    } else {
                        echo '<div class="timeline_bg_wrap"><div class="timeline_back clearfix">';
                    }
                }
            }
            if ($theme == "boxy" || $theme == "brit_co" || $theme == "glossary" || $theme == "invert-grid") {
                echo "<div class='bdp-row $theme'>";
            }
            if ($theme == "media-grid" || $theme == "chapter") {
                $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? 'column_layout_' . $bdp_settings['column_setting'] : 'column_layout_2';
                $column_setting_ipad = (isset($bdp_settings['column_setting_ipad']) && $bdp_settings['column_setting_ipad'] != '') ? 'column_layout_ipad_' . $bdp_settings['column_setting_ipad'] : 'column_layout_ipad_2';
                $column_setting_tablet = (isset($bdp_settings['column_setting_tablet']) && $bdp_settings['column_setting_tablet'] != '') ? 'column_layout_tablet_' . $bdp_settings['column_setting_tablet'] : 'column_layout_tablet_1';
                $column_setting_mobile = (isset($bdp_settings['column_setting_mobile']) && $bdp_settings['column_setting_mobile'] != '') ? 'column_layout_mobile_' . $bdp_settings['column_setting_mobile'] : 'column_layout_mobile_1';
                $column_class = $column_setting .' '. $column_setting_ipad .' '. $column_setting_tablet .' '. $column_setting_mobile;
                echo "<div class='bdp-row $column_class $theme'>";
            }
            if ($theme == 'glossary' || $theme == 'boxy') {
                echo '<div class="bdp-js-masonry masonry bdp_' . $theme . '">';
            }
            if ($theme == 'boxy-clean') {
                echo '<div class="blog_template boxy-clean"><ul>';
            }
            $slider_navigation = isset($bdp_settings['select_slider_navigation']) ? $bdp_settings['select_slider_navigation'] : 'navigation1';
            if ($theme == 'crayon_slider') {
                echo '<div class="blog_template slider_template crayon_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
            }
            if ($theme == 'sallet_slider') {
                echo '<div class="blog_template slider_template sallet_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
            }
            if ($theme == 'sunshiny_slider') {
                echo '<div class="blog_template slider_template sunshiny_slider ' . $slider_navigation . ' slider_' . $unique_id . '"><ul class="slides">';
            }
            if ($theme == 'cool_horizontal' || $theme == 'overlay_horizontal') {
                echo '<div class="logbook flatLine flatNav flatButton">';
            }
            if ($theme == 'easy_timeline') {
                echo '<div class="blog_template bdp_blog_template easy-timeline-wrapper"><ul class="easy-timeline" data-effect="' . $bdp_settings['easy_timeline_effect'] . '">';
            }
            if ($theme == 'my_diary') {
                echo '<div class="my_diary_wrapper">';
            }
            if ($theme == 'story') {
                echo '<div class="story_wrapper">';
            }
            if ($theme == 'brite') {
                echo '<div class="brite-wrapp">';
            }
            // Start the loop.
            $prev_year1 = null;
            $prev_year = null;
            $prev_month = null;
            while (have_posts()) : the_post();

                if (isset($bdp_settings['template_alternativebackground']) && $bdp_settings['template_alternativebackground'] == 1) {
                    if ($alter % 2 == 0) {
                        $alter_class = ' alternative-back';
                    } else {
                        $alter_class = '';
                    }
                }
                if ($theme == 'deport' || $theme == 'navia') {
                    if ($alter % 2 == 0) {
                        $alter_class = 'even_class';
                    } else {
                        $alter_class = '';
                    }
                }
                if ($theme == 'timeline') {
                    if ($alter % 2 == 0) {
                        $alter_class = 'even_class';
                    } else {
                        $alter_class = 'odd_class';
                    }
                }
                if ($theme == 'invert-grid' || $theme == 'media-grid' || $theme == 'boxy-clean' || $theme == 'story' || $theme == 'explore' || $theme == 'hoverbic') {
                    $alter_class = $alter;
                }
                if ($theme) {
                    if ($theme == 'timeline') {
                        if ($orderby == 'date' || $orderby == 'modified') {
                            if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_year') {
                                $this_year = get_the_date('Y');
                                if ($prev_year != $this_year) {
                                    $prev_year = $this_year;
                                    echo '<p class="timeline_year"><span class="year_wrap"><span class="only_year">' . $prev_year . '</span></span></p>';
                                }
                            } else if (isset($bdp_settings['timeline_display_option']) && $bdp_settings['timeline_display_option'] == 'display_month') {
                                $prev_month = "";
                                $this_year = get_the_date('Y');
                                $this_month = get_the_time('M');
                                $prev_year = $this_year;
                                if ($prev_month != $this_month) {
                                    $prev_month = $this_month;
                                    echo '<p class="timeline_year"><span class="year_wrap"><span class="year">' . $this_year . '</span><span class="month">' . $prev_month . '</span></span></p>';
                                }
                            }
                        }
                    }
                    if ($theme == 'story') {
                        if ($orderby == 'date' || $orderby == 'modified') {
                            $this_year = get_the_date('Y');
                            if ($prev_year1 != $this_year) {
                                $prev_year1 = $this_year;
                                $prev_year = 0;
                            } elseif ($prev_year1 == $this_year) {
                                $prev_year = 1;
                            }
                        } else {
                            $prev_year = get_the_date('Y');
                        }
                    }

                    if ($theme == 'media-grid') {
                        $alter_val = $alter;
                    }
                    if ($firstpost_unique_design == 1) {
                        if ($theme == 'invert-grid' || $theme == 'boxy-clean' || $theme == 'news' || $theme == 'deport' || $theme == 'navia') {
                            $alter_val = $alter;
                            if (1 == $paged) {
                                if ($alter == 1) {
                                    $prev_year = 0;
                                } else {
                                    $prev_year = 1;
                                }
                            } else {
                                $prev_year = 1;
                            }
                        }
                        if ($theme == 'media-grid') {
                            $column_setting = (isset($bdp_settings['column_setting']) && $bdp_settings['column_setting'] != '') ? $bdp_settings['column_setting'] : 2;
                            $alter_val = $alter;
                            if (1 == $paged) {
                                if ($column_setting >= 2 && $alter <= 2) {
                                    $prev_year = 0;
                                } else {
                                    if ($alter == 1) {
                                        $prev_year = 0;
                                    } else {
                                        $prev_year = 1;
                                    }
                                }
                            } else {
                                $prev_year = 1;
                            }
                        }
                    }
                }
                // Include the single post content template.
                bdp_get_template('archive/' . $theme . '.php');
                do_action('bd_archive_design_format_function', $bdp_settings, $alter_class, $prev_year, $alter_val, $paged);
                $alter ++;
            // End of the loop.
            endwhile;
            if ($theme == 'boxy-clean' || $theme == 'crayon_slider' || $theme == 'sallet_slider' || $theme == 'sunshiny_slider') {
                echo "</ul></div>";
            }
            if ($theme == 'glossary' || $theme == 'boxy' || $theme == "boxy" || $theme == "brit_co" || $theme == "glossary" || $theme == "invert-grid") {
                echo "</div>";
            }
            if ($theme == "media-grid" || $theme == "chapter") {
                echo "</div>";
            }
            if ($theme == 'timeline') {
                echo '</div>
                        </div>';
            }
            if ($theme == 'easy_timeline') {
                echo '</div></ul>';
            }
            if ($theme == "offer_blog" || $theme == "winter" || $theme == 'my_diary' || $theme == 'story' || $theme == 'brite' || $theme == 'cool_horizontal' || $theme == 'overlay_horizontal') {
                echo '</div>';
            }
            if (isset($bdp_settings['pagination_type']) && $bdp_settings['pagination_type'] != 'no_pagination' && ( is_author() || is_date() || is_category() || is_tag() || is_search() )) {
                echo '<div class="wl_pagination_box">';
                echo bdp_standard_paging_nav();
                echo '</div>';
            }
            if($main_container_class != '') {
                echo '</div">';
            }
            ?>
        </div>
        <?php do_action('bdp_after_archive_page'); ?>
    </main><!-- .site-main -->
</div><!-- .content-area -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>