<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_archive_design_format_function', 'bdp_archive_easy_timeline_template', 10, 1);
if (!function_exists('bdp_archive_easy_timeline_template')) {

    /**
     *
     * @global type $post
     */
    function bdp_archive_easy_timeline_template($bdp_settings) {
        global $post;
        $image_hover_effect = '';
        if(isset($bdp_settings['bdp_image_hover_effect']) && $bdp_settings['bdp_image_hover_effect'] == 1) {
            $image_hover_effect = (isset($bdp_settings['bdp_image_hover_effect_type']) && $bdp_settings['bdp_image_hover_effect_type'] != '') ? $bdp_settings['bdp_image_hover_effect_type'] : '';
        }
        ?>
        <?php do_action('bdp_before_archive_post_content'); ?>
        <li>

            <div class="post-title">
                <?php
                $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                if ($bdp_post_title_link == 1) {
                    echo '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '">';
                }
                echo get_the_title();
                if ($bdp_post_title_link == 1) {
                    echo '</a>';
                }
                ?>
            </div>
            <?php
            if ($bdp_settings['display_date'] == 1) {
                $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                $ar_year = get_the_time('Y');
                $ar_month = get_the_time('m');
                $ar_day = get_the_time('d');
                ?>
                <div class="mdate">
                    <i class="fa fa-calendar"></i>
                    <a href="<?php echo get_day_link($ar_year, $ar_month, $ar_day); ?>"><?php echo get_the_date(); ?></a>
                </div>
                <?php
            }
            if ($bdp_settings['display_feature_image'] == 1) {
                if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) {
                    ?>
                    <div class="post-image post-video">
                        <?php echo bdp_get_first_embed_media($post->ID); ?>
                    </div>
                    <?php
                } else {
                    $post_thumbnail = 'easy_timeline_img';
                    $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                    if (!empty($thumbnail)) {
                        echo '<figure class="'. $image_hover_effect .'">';
                        ?>
                        <div class="photo post-image">
                            <?php
                            echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                            echo get_the_date();
                            echo ($date_link) ? '</a>' : '';

                            if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                                echo bdp_pinterest($post->ID);
                            }
                            ?>
                        </div>
                        <?php
                        echo '</figure>';
                    }
                }
            }
            if ($bdp_settings['display_author'] == 1 || $bdp_settings['display_postlike'] == 1 || $bdp_settings['display_comment_count'] == 1) {
                echo '<div class="metadatabox">';
                if ($bdp_settings['display_author'] == 1) {
                    $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                    ?>
                    <span class="mauthor">
                        <i class="fa fa-user"></i>
                        <?php
                        echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                        echo get_the_author();
                        echo ($author_link) ? '</a>' : '';
                        ?>
                    </span>
                    <?php
                }

                if ($bdp_settings['display_comment_count'] == 1) {
                    ?>
                    <span class="mcomments">
                        <i class="fa fa-comment"></i>
                        <?php
                        if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                            comments_number(__('Leave a Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                        } else {
                            comments_popup_link(__('Leave a Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('comments', BLOGDESIGNERPRO_TEXTDOMAIN), 'comments-link', __('Comments are off', BLOGDESIGNERPRO_TEXTDOMAIN));
                        }
                        ?>
                    </span>
                    <?php
                }
                if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                    echo do_shortcode('[likebtn_shortcode]');
                }
                echo '</div>';
            }
            ?>

            <div class="post_content">
                <?php
                echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
                if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) {
                    echo '<div class="read-more-div"><a class="more-tag" href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a></div>';
                }
                ?>
            </div>
            <div class="blog_footer">
                <?php
                if ($bdp_settings['display_category'] == 1) {
                    ?>
                    <div class="categories">
                        <span class="link-lable"> <i class="fa fa-folder"></i> <?php _e('Categories', BLOGDESIGNERPRO_TEXTDOMAIN); ?>:&nbsp; </span>
                        <?php
                        $categories_list = get_the_category_list(', ');
                        $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                        if ($categories_link) {
                            $categories_list = strip_tags($categories_list);
                        }
                        if ($categories_list) {
                            print_r($categories_list);
                        }
                        ?>
                    </div>
                    <?php
                }
                if ($bdp_settings['display_tag'] == 1) {
                    $tags_list = get_the_tag_list('', ', ');
                    $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                    if ($tag_link) {
                        $tags_list = strip_tags($tags_list);
                    }
                    if ($tags_list) {
                        ?>
                        <div class="tags">
                            <span class="link-lable"> <i class="fa fa-bookmark"></i> <?php _e('Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?>:&nbsp; </span>
                            <?php printf($tags_list); ?>
                        </div>
                        <?php
                    }
                }
                bdp_get_social_icons($bdp_settings);
                ?>
            </div>
        </li>
        <?php do_action('bdp_after_archive_post_content'); ?>
        <?php
    }

}