<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

global $wp_version, $wpdb, $bdp_errors, $bdp_success, $bdp_settings;
$return = '';
$bdp_wp_auto_update = new bdp_wp_auto_update();
if (isset($_POST['bdp_sbt_purchasecode'])) {
    $sol_username = $_POST['sol_username'];
    $purchase_code = $_POST['sol_purchase_code'];
    $return = $bdp_wp_auto_update->update_license(trim($sol_username), trim($purchase_code));
}
if (isset($_POST['bdp_deregister_purchasecode'])) {
    $sol_username = $_POST['sol_username'];
    $purchase_code = $_POST['sol_purchase_code'];
    $return = $bdp_wp_auto_update->deregister_site(trim($sol_username), trim($purchase_code));
}
$sol_username = get_option('bdp_username');
$purchase_code = get_option('bdp_purchase_code');
$page = '';
if (isset($_GET['page']) && $_GET['page'] != '') {
    $page = $_GET['page'];
}
?>
<div class="bdp-admin bdp-license-page">
    <?php if ($return == 'correct') { ?>
        <div class="updated notice">
            <p><?php _e('License updated successfully.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
    <?php } else if ($return == 'used') {
        ?>
        <div class="error notice">
            <p><?php _e('License Key already used.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
        <?php
    } else if ($return == 'incorrect') {
        ?>
        <div class="error notice">
            <p><?php _e('Wrong license key.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
        <?php
    }
    else if ($return == 'unsuccess') {
        ?>
        <div class="error notice">
            <p><?php _e('Site is not registered with this license key.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
        <?php
    }
    else if ($return == 'success') {
        ?>
        <div class="updated notice">
            <p><?php _e('Site has been De-Registered successfully.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
        <?php
    }
    ?>
    <div class="bdp-panel-wrapper">
        <div class="bdp-panel-header">
            <h2><?php _e('License Key', BLOGDESIGNERPRO_TEXTDOMAIN); ?></h2>
        </div>
        <div class="bdp-panel-body">
            <form method="post" name="bdp_frm_purchasecode" id="bdp_frm_purchasecode">
                <p class="bdp-verify-key"><?php _e('Verify your key to get automatic update, notification on your wordpress dashboard.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
                <div class="bdp-panel-width">
                    <div class="bdp-txt-lable"><?php _e('Username', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                    <div class="bdp-control-input">
                        <input value="<?php echo $sol_username; ?>" required="" type="text" name="sol_username" id="sol_username" /><br/>
                        <b><i><small><?php _e( 'Username will be your registered username with ', BLOGDESIGNERPRO_TEXTDOMAIN ); ?><a target="blank" href="https://codecanyon.net/"><?php _e( 'codecanyon', BLOGDESIGNERPRO_TEXTDOMAIN ); ?></a></small></i></b>
                    </div>
                </div>
                <div class="bdp-panel-width">
                    <div class="bdp-txt-lable"><?php _e('License Key', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                    <div class="bdp-control-input">
                        <input value="<?php echo $purchase_code; ?>" required="" type="password" name="sol_purchase_code" id="sol_purchase_code" />
                    </div>
                </div>
                <div class="bdp-panel-width bdp-update-licence">
                    <div class="bdp-control-button">
                        <input class="bdp-btn-success" type="submit" value="<?php echo ($sol_username != '') ? __('Update License', BLOGDESIGNERPRO_TEXTDOMAIN) : __('Add License', BLOGDESIGNERPRO_TEXTDOMAIN) ?>" name="bdp_sbt_purchasecode" />
                        <?php if($sol_username != '') { ?>
                        <input class="bdp-btn-error" type="submit" value="<?php echo __('De-Register Site', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" name="bdp_deregister_purchasecode" />
                        <?php } ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="bdp-panel-wrapper bdp-right-panel-wrapper">
        <div class="bdp-panel-header">
            <h2><?php _e( 'How To get Purchase code?', BLOGDESIGNERPRO_TEXTDOMAIN ); ?></h2>
        </div>
        <div class="bdp-panel-body bdp-get-license-key">
            <a target="blank" href="<?php echo esc_url('https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code'); ?>"> <?php _e('Click here', BLOGDESIGNERPRO_TEXTDOMAIN); ?> </a> <?php _e('to know how to get purchase code.', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
        </div>
    </div>
</div>