<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $wp_version, $wpdb, $bdp_errors, $bdp_success, $bdp_settings;
if (isset($_GET['page']) && $_GET['page'] == 'single_post') {
    $page = $_GET['page'];
    $bdp_settings = array();
    $custom_single_type = '';
    $single_template_name = '';
    if (isset($_GET['id']) && !empty($_GET['id'])) {
        $single_id = $_GET['id'];
        $tableName = $wpdb->prefix . 'bdp_single_layouts';
        $getQry = "SELECT * FROM $tableName WHERE ID = $single_id";
        $get_allsettings = $wpdb->get_results($getQry, ARRAY_A);
        if (!isset($get_allsettings[0]['settings'])) {
            echo '<div class="updated notice">';
            wp_die(__('You attempted to edit an item that doesn’t exist. Perhaps it was deleted?', BLOGDESIGNERPRO_TEXTDOMAIN));
            echo '</div>';
        }
        $allsettings = $get_allsettings[0]['settings'];
        if (is_serialized($allsettings)) {
            $bdp_settings = unserialize($allsettings);
            $custom_single_type = $get_allsettings[0]['single_template'];
            $single_template_name = $get_allsettings[0]['single_name'];
        }
    }
}
$font_family = bdp_default_recognized_font_faces();
$template_name = isset($bdp_settings['template_name']) ? $bdp_settings['template_name'] : 'classical';

if ($template_name == 'brite') {
    $winter_category_txt = __('Choose Tags Background Color', BLOGDESIGNERPRO_TEXTDOMAIN);
    ;
} else {
    $winter_category_txt = __('Choose Category Background Color', BLOGDESIGNERPRO_TEXTDOMAIN);
}
?>
<div class="wrap">
    <h1>
        <?php
        if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
            _e('Edit Single Post Design', BLOGDESIGNERPRO_TEXTDOMAIN);
        } else {
            _e('Add Single Post Layout', BLOGDESIGNERPRO_TEXTDOMAIN);
        }
        if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
            ?>
            <a class="page-title-action" href="?page=single_post">
                <?php _e('Create New Single Layout', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
            </a>
            <?php
        }
        if (isset($_GET['message']) && $_GET['message'] == 'shortcode_duplicate_msg') {
            ?>
            <div class="updated notice">
                <p><?php _e('Layout duplicated successfully. Please Select Post Categories or Tags and Select Posts for this layout.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
            </div>
            <?php
        }
        ?>
    </h1>
    <?php
    if (isset($bdp_errors)) {
        if (is_wp_error($bdp_errors)) {
            ?>
            <div class="error notice">
                <p><?php echo $bdp_errors->get_error_message(); ?></p>
            </div>
            <?php
        }
    }
    if (isset($bdp_success)) {
        ?>
        <div class="updated notice">
            <p><?php echo $bdp_success; ?></p>
        </div>
        <?php
    }
    if (isset($_GET['message']) && $_GET['message'] == 'single_added_msg') {
        ?>
        <div class="updated notice">
            <p><?php _e('Single layout added successfully.', BLOGDESIGNERPRO_TEXTDOMAIN); ?></p>
        </div>
        <?php
    }
    ?>
    <form method="post" id="single-layout-form" onsubmit="setFormSubmitting()" action="" class="bd-form-class single-layout">
        <?php
        wp_nonce_field('bdp-shortcode-form-submit', 'bdp-submit-nonce');
        $page = '';
        if (isset($_GET['page']) && $_GET['page'] != '') {
            $page = $_GET['page'];
            ?>
            <input type="hidden" name="originalpage" class="bdporiginalpage" value="<?php echo $page; ?>">
        <?php } ?>
        <div id="poststuff">
            <div class="postbox-container bd-settings-wrappers bd_poststuff">
                <div class="bd-header-wrapper">
                    <div class="bd-logo-wrapper pull-left">
                        <h3><?php _e('Blog designer settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></h3>
                    </div>
                    <div class="pull-right">
                        <a id="bdp-btn-single" title="<?php _e('Save Changes', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" class="show_single_save button submit_fixed button-primary">
                            <span><?php _e('Save Changes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </a>
                        <input type="submit" style="display:none;" class="button-primary bdp_single_save_btn" name="savedata" value="<?php esc_attr_e('Save Changes', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" /><?php if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) { ?>
                            <input type="submit" class="button-secondary bdp-reset-data" name="resetdata" value="<?php esc_attr_e('Reset Changes', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" /><?php }
        ?>
                <!--<p class="wl-saving-warning"></p>-->
                    </div>
                </div>
                <div class="bd-menu-setting">
                    <?php
                    $bdpgeneral_class = $bdpmedia_class = $bdpstandard_class = $bdptitle_class = $bdpauthor_class = $bdpcontent_class = $bdprelatd_class = $bdpsinglepostnavigation_class = $bdpsocial_class = '';
                    $bdpgeneral_class_show = $bdpmedia_class_show = $bdpstandard_class_show = $bdptitle_class_show = $bdpauthor_class_show = $bdpcontent_class_show = $bdprelated_class_show = $bdpsinglepostnavigation_class_show = $bdpsocial_class_show = '';
                    if (bdp_postbox_classes('bdpsinglegeneral', $page)) {
                        $bdpgeneral_class = 'class="bd-active-tab"';
                        $bdpgeneral_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglestandard', $page)) {
                        $bdpstandard_class = 'class="bd-active-tab"';
                        $bdpstandard_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsingletitle', $page)) {
                        $bdptitle_class = 'class="bd-active-tab"';
                        $bdptitle_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglepostauthor', $page)) {
                        $bdpauthor_class = 'class="bd-active-tab"';
                        $bdpauthor_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsingleconent', $page)) {
                        $bdpcontent_class = 'class="bd-active-tab"';
                        $bdpcontent_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglemedia', $page)) {
                        $bdpmedia_class = 'class="bd-active-tab"';
                        $bdpmedia_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglerelated', $page)) {
                        $bdprelatd_class = 'class="bd-active-tab"';
                        $bdprelated_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglepostnavigation', $page)) {
                        $bdpsinglepostnavigation_class = 'class="bd-active-tab"';
                        $bdpsinglepostnavigation_class_show = 'style="display: block;"';
                    } elseif (bdp_postbox_classes('bdpsinglesocial', $page)) {
                        $bdpsocial_class = 'class="bd-active-tab"';
                        $bdpsocial_class_show = 'style="display: block;"';
                    } else {
                        $bdpgeneral_class = 'class="bd-active-tab"';
                        $bdpgeneral_class_show = 'style="display: block;"';
                    }
                    ?>
                    <ul class="bd-setting-handle">
                        <li data-show="bdpsinglegeneral" <?php echo $bdpgeneral_class; ?>>
                            <i class="fa fa-gear"></i>
                            <span><?php _e('General Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglestandard" <?php echo $bdpstandard_class; ?>>
                            <i class="fa fa-legal"></i>
                            <span><?php _e('Standard Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsingletitle" <?php echo $bdptitle_class; ?>>
                            <i class="fa fa-chain"></i>
                            <span><?php _e('Title Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsingleconent" <?php echo $bdpcontent_class; ?>>
                            <i class="fa fa-gears"></i>
                            <span><?php _e('Content Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglemedia" <?php echo $bdpmedia_class; ?>>
                            <i class="fa fa-picture-o"></i>
                            <span><?php _e('Media Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglepostnavigation" <?php echo $bdpsinglepostnavigation_class; ?>>
                            <i class="fa fa-sort"></i>
                            <span><?php _e('Post Navigation (Next/Previous) Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglepostauthor" <?php echo $bdpauthor_class; ?>>
                            <i class="fa fa-user"></i>
                            <span><?php _e('Author Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglerelated" <?php echo $bdprelatd_class; ?>>
                            <i class="fa fa-th-large"></i>
                            <span><?php _e('Related Post Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                        <li data-show="bdpsinglesocial" <?php echo $bdpsocial_class; ?>>
                            <i class="fa fa-share-alt"></i>
                            <span><?php _e('Social Share Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        </li>
                    </ul>
                </div>
                <div id="bdpsinglegeneral" class="postbox postbox-with-fw-options"<?php echo $bdpgeneral_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select single post layout template for single page design', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Single Post Designs', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <div class="select_button_upper_div">
                                            <div class="bdp_select_template_button_div">
                                                <input type="button" class="bdp_select_template" value="<?php esc_attr_e('Select Template', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                                                <input type="hidden" class="bdp_template_name <?php
                                                if (isset($_GET['page']) && $_GET['page'] == 'add_shortcode' && !isset($_GET['action'])) {
                                                    echo 'bdp-create-shortcode';
                                                }
                                                ?>" value="<?php
                                                       if ($template_name) {
                                                           echo $template_name;
                                                       }
                                                       ?>" name="template_name">

                                            </div>
                                            <div class="bdp_selected_template_image">
                                                <div <?php
                                                $template_name = isset($bdp_settings['template_name']) ? $bdp_settings['template_name'] : 'classical';
                                                if ($template_name == '') {
                                                    echo ' class="bdp_no_template_found"';
                                                }
                                                ?>>
                                                        <?php
                                                        if ($template_name != '') {
                                                            $image_name = $template_name . '.jpg';
                                                            ?>
                                                        <img src="<?php echo BLOGDESIGNERPRO_URL . '/admin/images/single/' . $image_name; ?>" alt="<?php
                                                        if ($template_name) {
                                                            echo str_replace('_', '-', $template_name).' ';
                                                            esc_attr_e('Template', BLOGDESIGNERPRO_TEXTDOMAIN);
                                                        }
                                                        ?>" title="<?php
                                                             if ($template_name) {
                                                                 echo str_replace('_', '-', $template_name).' ';
                                                                 esc_attr_e('Template', BLOGDESIGNERPRO_TEXTDOMAIN);
                                                             }
                                                             ?>" />
                                                        <label id="template_select_name"><?php
                                                            if ($template_name) {
                                                                echo str_replace('_', '-', $template_name).' ';
                                                                _e('Template', BLOGDESIGNERPRO_TEXTDOMAIN);
                                                            }
                                                            ?>
                                                        </label>
                                                        <?php
                                                    } else {
                                                        _e('No template exist for selection', BLOGDESIGNERPRO_TEXTDOMAIN);
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select color preset', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Template Color Preset', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $bdp_color_preset = isset($bdp_settings['bdp_color_preset']) ? $bdp_settings['bdp_color_preset'] : $template_name . '_default';
                                        $template_color_preset = array(
                                            'boxy' => array(
                                                'boxy_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#E84159,template_ftcolor:#555555,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#E21130,#E84159,#555555,#999999'
                                                ),
                                                'boxy_mckenzie' => array(
                                                    'preset_name' => __('McKenzie', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#A2855B,template_ftcolor:#555555,template_fthovercolor:#A2855B,template_titlecolor:#8B6632,related_title_color:#8B6632,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#8B6632,#A2855B,#555555,#999999'
                                                ),
                                                'boxy_black_pearl' => array(
                                                    'preset_name' => __('Black Pearl', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#44545D,template_ftcolor:#555555,template_fthovercolor:#44545D,template_titlecolor:#152934,related_title_color:#152934,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#152934,#44545D,#555555,#999999'
                                                ),
                                                'boxy_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#3E8563,template_ftcolor:#555555,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#0E663C,#3E8563,#555555,#999999'
                                                ),
                                                'boxy_peru_tan' => array(
                                                    'preset_name' => __('Peru Tan', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#916748,template_ftcolor:#555555,template_fthovercolor:#916748,template_titlecolor:#75411A,related_title_color:#75411A,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#75411A,#916748,#555555,#999999'
                                                ),
                                                'boxy_blackberry' => array(
                                                    'preset_name' => __('Blackberry', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#6D4657,template_ftcolor:#555555,template_fthovercolor:#6D4657,template_titlecolor:#49182D,related_title_color:#49182D,template_contentcolor:#999999,firstletter_contentcolor:#999999,',
                                                    'display_value' => '#49182D,#6D4657,#555555,#999999'
                                                ),
                                            ),
                                            'boxy-clean' => array(
                                                'boxy-clean_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#3E91AD,template_ftcolor:#555555,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#888888'
                                                ),
                                                'boxy-clean_mandalay' => array(
                                                    'preset_name' => __('Mandalay', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#C18F55,template_ftcolor:#555555,template_fthovercolor:#C18F55,template_titlecolor:#B1732A,related_title_color:#B1732A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#B1732A,#C18F55,#555555,#888888'
                                                ),
                                                'boxy-clean_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#ED4961,template_ftcolor:#555555,template_fthovercolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E81B3A,#ED4961,#555555,#888888'
                                                ),
                                                'boxy-clean_mckenzie' => array(
                                                    'preset_name' => __('McKenzie', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#A2855B,template_ftcolor:#555555,template_fthovercolor:#A2855B,template_titlecolor:#8B6632,related_title_color:#8B6632,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#8B6632,#A2855B,#555555,#888888'
                                                ),
                                                'boxy-clean_blackberry' => array(
                                                    'preset_name' => __('Blackberry', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#6D4657,template_ftcolor:#555555,template_fthovercolor:#6D4657,template_titlecolor:#49182D,related_title_color:#49182D,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#49182D,#6D4657,#555555,#888888'
                                                ),
                                                'boxy-clean_regal_blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#435F7F,template_ftcolor:#555555,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#14375F,#435F7F,#555555,#888888'
                                                ),
                                            ),
                                            'brit_co' => array(
                                                'brit_co_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#666666'
                                                ),
                                                'brit_co_pompadour' => array(
                                                    'preset_name' => __('Pompadour', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#974772,template_titlecolor:#7D194F,related_title_color:#7D194F,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#7D194F,#974772,#555555,#666666'
                                                ),
                                                'brit_co_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#414C22,#67704E,#555555,#666666'
                                                ),
                                                'brit_co_west_side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF6F1,template_ftcolor:#555555,template_fthovercolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#E4802A,#E99955,#555555,#666666'
                                                ),
                                                'brit_co_regal_blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#EEF1F4,template_ftcolor:#555555,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#14375F,#435F7F,#555555,#666666'
                                                ),
                                                'brit_co_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#EEF4F1,template_ftcolor:#555555,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#0E663C,#3E8563,#555555,#666666'
                                                ),
                                            ),
                                            'brite' => array(
                                                'brite_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#3E91AD,winter_category_color:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#999999'
                                                ),
                                                'brite_mandalay' => array(
                                                    'preset_name' => __('Mandalay', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#C18F55,winter_category_color:#C18F55,template_titlecolor:#B1732A,related_title_color:#B1732A,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#B1732A,#C18F55,#555555,#999999'
                                                ),
                                                'brite_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#67704E,winter_category_color:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#414C22,#67704E,#555555,#999999'
                                                ),
                                                'brite_red_violet' => array(
                                                    'preset_name' => __('Red Violet', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#C44C91,winter_category_color:#C44C91,template_titlecolor:#B51F76,related_title_color:#B51F76,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#B51F76,#C44C91,#555555,#999999'
                                                ),
                                                'brite_peru_tan' => array(
                                                    'preset_name' => __('Peru Tan', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#916748,winter_category_color:#916748,template_titlecolor:#75411A,related_title_color:#75411A,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#75411A,#916748,#555555,#999999'
                                                ),
                                                'brite_earls_green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#CEBF59,winter_category_color:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#999999'
                                                ),
                                            ),
                                            'chapter' => array(
                                                'chapter_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E21130,#E84159,#555555,#888888'
                                                ),
                                                'chapter_earls_green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#888888'
                                                ),
                                                'chapter_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#888888'
                                                ),
                                                'chapter_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#414C22,#67704E,#555555,#888888'
                                                ),
                                                'chapter_ce_soir' => array(
                                                    'preset_name' => __('Ce Soir', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#A381BB,template_titlecolor:#8C62AA,related_title_color:#8C62AA,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#8C62AA,#A381BB,#555555,#888888'
                                                ),
                                                'chapter_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#555555,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#555555,#888888'
                                                ),
                                            ),
                                            'classical' => array(
                                                'classical_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#3E91AD,template_ftcolor:#3E91AD,template_fthovercolor:#555555,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#777777'
                                                ),
                                                'classical_rich_gold' => array(
                                                    'preset_name' => __('Rich Gold', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#BA7850,template_ftcolor:#BA7850,template_fthovercolor:#555555,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#A95624,#BA7850,#555555,#777777'
                                                ),
                                                'classical_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#67704E,template_ftcolor:#67704E,template_fthovercolor:#555555,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#414C22,#67704E,#555555,#777777'
                                                ),
                                                'classical_terracotta' => array(
                                                    'preset_name' => __('Terracotta', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#B06F6D,template_ftcolor:#B06F6D,template_fthovercolor:#555555,template_titlecolor:#9C4B48,related_title_color:#9C4B48,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#9C4B48,#B06F6D,#555555,#777777'
                                                ),
                                                'classical_buttercup' => array(
                                                    'preset_name' => __('Buttercup', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF7F1,template_color:#E5A452,template_ftcolor:#E5A452,template_fthovercolor:#555555,template_titlecolor:#DF8D27,related_title_color:#DF8D27,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#DF8D27,#E5A452,#555555,#777777'
                                                ),
                                                'classical_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F6F7F1,template_color:#93A564,template_ftcolor:#93A564,template_fthovercolor:#555555,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#788F3D,#93A564,#555555,#777777'
                                                )
                                            ),
                                            'cool_horizontal' => array(
                                                'cool_horizontal_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#e21130,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#e21130,related_title_color:#e21130,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#e21130,#666666,#e21130,#444444'
                                                ),
                                                'cool_horizontal_pink' => array(
                                                    'preset_name' => __('Pink', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#D33683,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#D33683,related_title_color:#D33683,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#D33683,#666666,#D33683,#444444'
                                                ),
                                                'cool_horizontal_blue' => array(
                                                    'preset_name' => __('Chetwode Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#6C71C3,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#6C71C3,related_title_color:#6C71C3,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#6C71C3,#666666,#6C71C3,#444444'
                                                ),
                                                'cool_horizontal_java' => array(
                                                    'preset_name' => __('Java', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#29A198,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#29A198,related_title_color:#29A198,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#29A198,#666666,#29A198,#444444'
                                                ),
                                                'cool_horizontal_curious_blue' => array(
                                                    'preset_name' => __('Curious Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#268BD3,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#268BD3,related_title_color:#268BD3,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#268BD3,#666666,#268BD3,#444444'
                                                ),
                                                'cool_horizontal_olive' => array(
                                                    'preset_name' => __('Olive', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#869901,template_ftcolor:#666666,template_fthovercolor:#333333,template_titlecolor:#869901,related_title_color:#869901,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#869901,#666666,#869901,#444444'
                                                ),
                                            ),
                                            'deport' => array(
                                                'deport_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#3E91AD,template_ftcolor:#555555,template_fthovercolor:#3E91AD,deport_dashcolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#888888'
                                                ),
                                                'deport_west_side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#E99955,template_ftcolor:#555555,template_fthovercolor:#E99955,deport_dashcolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E4802A,#E99955,#555555,#888888'
                                                ),
                                                'deport_lemon_ginger' => array(
                                                    'preset_name' => __('Lemon Ginger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#CEBF59,template_ftcolor:#555555,template_fthovercolor:#CEBF59,deport_dashcolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#888888'
                                                ),
                                                'deport_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#ED4961,template_ftcolor:#555555,template_fthovercolor:#ED4961,deport_dashcolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E81B3A,#ED4961,#555555,#888888'
                                                ),
                                                'deport_ce_soir' => array(
                                                    'preset_name' => __('Ce Soir', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#A381BB,template_ftcolor:#555555,template_fthovercolor:#A381BB,deport_dashcolor:#A381BB,template_titlecolor:#8C62AA,related_title_color:#8C62AA,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#8C62AA,#A381BB,#555555,#888888'
                                                ),
                                                'deport_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#8BA3CE,template_ftcolor:#555555,template_fthovercolor:#8BA3CE,deport_dashcolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#555555,#888888'
                                                ),
                                            ),
                                            'easy_timeline' => array(
                                                'easy_timeline_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#E21130,template_fthovercolor:#444444,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#E21130,#999999,#444444,#666666'
                                                ),
                                                'easy_timeline_dim_gray' => array(
                                                    'preset_name' => __('Dim Gray', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#666666,template_fthovercolor:#f1f1f1,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#444444,firstletter_contentcolor:#444444',
                                                    'display_value' => '#666666,#999999,#444444,#444444'
                                                ),
                                                'easy_timeline_flamenco' => array(
                                                    'preset_name' => __('Flamenco', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#E18942,template_fthovercolor:#999999,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#E18942,#999999,#444444,#666666'
                                                ),
                                                'easy_timeline_jagger' => array(
                                                    'preset_name' => __('Jagger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#3D3242,template_fthovercolor:#999999,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#3D3242,#999999,#444444,#666666'
                                                ),
                                                'easy_timeline_camelot' => array(
                                                    'preset_name' => __('Camelot', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#7A3E48,template_fthovercolor:#999999,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#7A3E48,#999999,#444444,#666666'
                                                ),
                                                'easy_timeline_sundance' => array(
                                                    'preset_name' => __('Sundance', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#bfbfbf,template_ftcolor:#C59F4A,template_fthovercolor:#999999,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#C59F4A,#999999,#444444,#666666'
                                                ),
                                            ),
                                            'elina' => array(
                                                'elina_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#E84159,template_fthovercolor:#333333,template_titlecolor:#333333,related_title_color:#333333,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E21130,#E84159,#333333,#555555'
                                                ),
                                                'elina_madras' => array(
                                                    'preset_name' => __('Madras', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#6D6145,template_titlecolor:#493917,related_title_color:#493917,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#493917,#6D6145,#333333,#555555'
                                                ),
                                                'elina_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#3E91AD,#333333,#555555'
                                                ),
                                                'elina_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#414C22,#67704E,#333333,#555555'
                                                ),
                                                'elina_buttercup' => array(
                                                    'preset_name' => __('Buttercup', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF7F1,template_ftcolor:#333333,template_fthovercolor:#E5A452,template_titlecolor:#DF8D27,related_title_color:#DF8D27,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#DF8D27,#E5A452,#333333,#555555'
                                                ),
                                                'elina_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF7F1,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                ),
                                            ),
                                            'evolution' => array(
                                                'evolution_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#3E91AD,#333333,#555555'
                                                ),
                                                'evolution_rich_gold' => array(
                                                    'preset_name' => __('Rich Gold', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F4E9E1,template_ftcolor:#333333,template_fthovercolor:#BA7850,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#A95624,#BA7850,#333333,#555555'
                                                ),
                                                'evolution_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FCE1E4,template_ftcolor:#333333,template_fthovercolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E81B3A,#ED4961,#333333,#555555'
                                                ),
                                                'evolution_west_side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FBEDE2,template_ftcolor:#333333,template_fthovercolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E4802A,#E99955,#333333,#555555'
                                                ),
                                                'evolution_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#DFEAE5,template_ftcolor:#333333,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E663C,#3E8563,#333333,#555555'
                                                ),
                                                'evolution_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ECF0F7,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                ),
                                            ),
                                            'explore' => array(
                                                'explore_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#44545D,template_titlecolor:#152934,related_title_color:#152934,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#152934,#44545D,#333333,#555555'
                                                ),
                                                'explore_lemon_ginger' => array(
                                                    'preset_name' => __('Lemon Ginger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#A39D5A,template_titlecolor:#8C8431,related_title_color:#8C8431,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8C8431,#A39D5A,#333333,#555555'
                                                ),
                                                'explore_rich_gold' => array(
                                                    'preset_name' => __('Rich Gold', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#BA7850,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#A95624,#BA7850,#333333,#555555'
                                                ),
                                                'explore_catalina_blue' => array(
                                                    'preset_name' => __('Catalina Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F0F1F4,template_ftcolor:#333333,template_fthovercolor:#495F85,template_titlecolor:#1B3766,related_title_color:#1B3766,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#1B3766,#495F85,#333333,#555555'
                                                ),
                                                'explore_red_violet' => array(
                                                    'preset_name' => __('Red Violet', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FAF0F6,template_ftcolor:#333333,template_fthovercolor:#C44C91,template_titlecolor:#B51F76,related_title_color:#B51F76,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#B51F76,#C44C91,#333333,#555555'
                                                ),
                                                'explore_blackberry' => array(
                                                    'preset_name' => __('Blackberry', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F3F0F1,template_ftcolor:#333333,template_fthovercolor:#6D4657,template_titlecolor:#49182D,related_title_color:#49182D,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#49182D,#6D4657,#333333,#555555'
                                                ),
                                            ),
                                            'glossary' => array(
                                                'glossary_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#ea4335,template_fthovercolor:#555555,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#ea4335,#222222,#555555,#888888'
                                                ),
                                                'glossary_madras' => array(
                                                    'preset_name' => __('Madras', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#6D6145,template_titlecolor:#493917,related_title_color:#493917,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#493917,#6D6145,#555555,#888888'
                                                ),
                                                'glossary_catalina_blue' => array(
                                                    'preset_name' => __('Catalina Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#495F85,template_titlecolor:#1B3766,related_title_color:#1B3766,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#1B3766,#495F85,#555555,#888888'
                                                ),
                                                'glossary_pompadour' => array(
                                                    'preset_name' => __('Pompadour', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#974772,template_titlecolor:#7D194F,related_title_color:#7D194F,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#7D194F,#974772,#555555,#888888'
                                                ),
                                                'glossary_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#414C22,#67704E,#555555,#888888'
                                                ),
                                                'glossary_peru-tan' => array(
                                                    'preset_name' => __('Peru Tan', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#916748,template_titlecolor:#75411A,related_title_color:#75411A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#75411A,#916748,#555555,#888888'
                                                ),
                                            ),
                                            'hub' => array(
                                                'hub_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#0E7699,template_fthovercolor:#555555,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#222222,#555555,#888888'
                                                ),
                                                'hub_crimson' => array(
                                                    'preset_name' => __('Crimson', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E21130,#E84159,#555555,#888888'
                                                ),
                                                'hub_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#414C22,#67704E,#555555,#888888'
                                                ),
                                                'hub_west_side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E4802A,#E99955,#555555,#888888'
                                                ),
                                                'hub_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#93A564,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#788F3D,#93A564,#555555,#888888'
                                                ),
                                                'hub_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#555555,#888888'
                                                ),
                                            ),
                                            'invert-grid' => array(
                                                'invert-grid_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#47c2dc,template_ftcolor:#d35400,template_fthovercolor:#555555,template_titlecolor:#333333,related_title_color:#333333,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#47c2dc,#d35400,#333333,#555555'
                                                ),
                                                'invert-grid_mckenzie' => array(
                                                    'preset_name' => __('McKenzie', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#8B6632,template_ftcolor:#A2855B,template_fthovercolor:#333333,template_titlecolor:#333333,related_title_color:#333333,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8B6632,#A2855B,#333333,#555555'
                                                ),
                                                'invert-grid_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#3E8563,template_ftcolor:#333333,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E663C,#3E8563,#333333,#555555'
                                                ),
                                                'invert-grid_blackberry' => array(
                                                    'preset_name' => __('Blackberry', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#6D4657,template_ftcolor:#333333,template_fthovercolor:#6D4657,template_titlecolor:#49182D,related_title_color:#49182D,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#49182D,#6D4657,#333333,#555555'
                                                ),
                                                'invert-grid_buttercup' => array(
                                                    'preset_name' => __('Buttercup', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#E5A452,template_ftcolor:#333333,template_fthovercolor:#E5A452,template_titlecolor:#DF8D27,related_title_color:#DF8D27,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#DF8D27,#E5A452,#333333,#555555'
                                                ),
                                                'invert-grid_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#ED4961,template_ftcolor:#333333,template_fthovercolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E81B3A,#ED4961,#333333,#555555'
                                                )
                                            ),
                                            'lightbreeze' => array(
                                                'lightbreeze_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#f5ab35,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#f5ab35,#ffffff,#4c4c4c,#808080'
                                                ),
                                                'lightbreeze_pink' => array(
                                                    'preset_name' => __('Pink', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FEF5F8,template_ftcolor:#e21130,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#e21130,#FEF5F8,#4c4c4c,#808080'
                                                ),
                                                'lightbreeze_solitude' => array(
                                                    'preset_name' => __('Solitude', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FFF3E5,template_ftcolor:#FF8A00,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#FF8A00,#FFF3E5,#4c4c4c,#808080'
                                                ),
                                            ),
                                            'masonry_timeline' => array(
                                                'masonry_timeline_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#E21130,template_fthovercolor:#333333,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E21130,#222222,#333333,#555555'
                                                ),
                                                'masonry_timeline_lemon_ginger' => array(
                                                    'preset_name' => __('Lemon Ginger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#8C8431,template_fthovercolor:#333333,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8C8431,#222222,#333333,#555555'
                                                ),
                                                'masonry_timeline_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#3E91AD,#333333,#555555'
                                                ),
                                                'masonry_timeline_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                ),
                                                'masonry_timeline_peru_tan' => array(
                                                    'preset_name' => __('Peru Tan', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#916748,template_titlecolor:#75411A,related_title_color:#75411A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#75411A,#916748,#333333,#555555'
                                                ),
                                                'masonry_timeline_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E663C,#3E8563,#333333,#555555'
                                                ),
                                            ),
                                            'media-grid' => array(
                                                'media-grid_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#3E91AD,template_ftcolor:#3E91AD,template_fthovercolor:#333333,template_titlecolor:#333333,related_title_color:#0E7699,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#3E91AD,#333333,#555555'
                                                ),
                                                'media-grid_rich_gold' => array(
                                                    'preset_name' => __('Rich Gold', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#BA7850,template_ftcolor:#333333,template_fthovercolor:#BA7850,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#A95624,#BA7850,#333333,#555555'
                                                ),
                                                'media-grid_pompadour' => array(
                                                    'preset_name' => __('Pompadour', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#974772,template_ftcolor:#333333,template_fthovercolor:#974772,template_titlecolor:#7D194F,related_title_color:#7D194F,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#7D194F,#974772,#333333,#555555'
                                                ),
                                                'media-grid_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#67704E,template_ftcolor:#333333,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#414C22,#67704E,#333333,#555555'
                                                ),
                                                'media-grid_ce_soir' => array(
                                                    'preset_name' => __('Ce Soir', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#A381BB,template_ftcolor:#333333,template_fthovercolor:#A381BB,template_titlecolor:#8C62AA,related_title_color:#8C62AA,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8C62AA,#A381BB,#333333,#555555'
                                                ),
                                                'media-grid_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#8BA3CE,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                )
                                            ),
                                            'my_diary' => array(
                                                'my_diary_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E21130,#E84159,#333333,#555555'
                                                ),
                                                'my_diary_lemon_ginger' => array(
                                                    'preset_name' => __('Lemon Ginger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#A39D5A,template_titlecolor:#8C8431,related_title_color:#8C8431,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8C8431,#A39D5A,#333333,#555555'
                                                ),
                                                'my_diary_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#3E91AD,#333333,#555555'
                                                ),
                                                'my_diary_mandalay' => array(
                                                    'preset_name' => __('Mandalay', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#BA7850,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#A95624,#BA7850,#333333,#555555'
                                                ),
                                                'my_diary_regal_blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#EEF1F4,template_ftcolor:#333333,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#14375F,#435F7F,#333333,#555555'
                                                ),
                                                'my_diary_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F5F7FB,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                ),
                                            ),
                                            'navia' => array(
                                                'navia_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#0E7699,template_fthovercolor:#555555,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#0E7699,#222222,#555555,#999999'
                                                ),
                                                'navia_toddy' => array(
                                                    'preset_name' => __('Toddy', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#BE9055,template_titlecolor:#AE742A,related_title_color:#AE742A,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#AE742A,#BE9055,#555555,#999999'
                                                ),
                                                'navia_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#414C22,#67704E,#555555,#999999'
                                                ),
                                                'navia_regal_blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#14375F,#435F7F,#555555,#999999'
                                                ),
                                                'navia_claret' => array(
                                                    'preset_name' => __('Claret', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#93425D,template_titlecolor:#781335,related_title_color:#781335,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#781335,#93425D,#555555,#999999'
                                                ),
                                                'navia_earls_green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#999999'
                                                ),
                                            ),
                                            'news' => array(
                                                'news_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#A95624,template_fthovercolor:#555555,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#A95624,#222222,#555555,#999999'
                                                ),
                                                'news_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#999999'
                                                ),
                                                'news_pompadour' => array(
                                                    'preset_name' => __('Pompadour', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#974772,template_titlecolor:#7D194F,related_title_color:#7D194F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#7D194F,#974772,#555555,#999999'
                                                ),
                                                'news_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#E81B3A,#ED4961,#555555,#999999'
                                                ),
                                                'news_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#93A564,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#788F3D,#93A564,#555555,#999999'
                                                ),
                                                'news_earls_green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#999999'
                                                ),
                                            ),
                                            'nicy' => array(
                                                'nicy_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#3E91AD,template_ftcolor:#3E91AD,template_fthovercolor:#555555,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#777777'
                                                ),
                                                'nicy_rich_gold' => array(
                                                    'preset_name' => __('Rich Gold', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#BA7850,template_ftcolor:#BA7850,template_fthovercolor:#555555,template_titlecolor:#A95624,related_title_color:#A95624,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#A95624,#BA7850,#555555,#777777'
                                                ),
                                                'nicy_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#67704E,template_ftcolor:#67704E,template_fthovercolor:#555555,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#414C22,#67704E,#555555,#777777'
                                                ),
                                                'nicy_terracotta' => array(
                                                    'preset_name' => __('Terracotta', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#B06F6D,template_ftcolor:#B06F6D,template_fthovercolor:#555555,template_titlecolor:#9C4B48,related_title_color:#9C4B48,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#9C4B48,#B06F6D,#555555,#777777'
                                                ),
                                                'nicy_buttercup' => array(
                                                    'preset_name' => __('Buttercup', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF7F1,template_color:#E5A452,template_ftcolor:#E5A452,template_fthovercolor:#555555,template_titlecolor:#DF8D27,related_title_color:#DF8D27,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#DF8D27,#E5A452,#555555,#777777'
                                                ),
                                                'nicy_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F6F7F1,template_color:#93A564,template_ftcolor:#93A564,template_fthovercolor:#555555,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#777777,firstletter_contentcolor:#777777',
                                                    'display_value' => '#788F3D,#93A564,#555555,#777777'
                                                )
                                            ),
                                            'offer_blog' => array(
                                                'offer_blog_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#0E7699,template_fthovercolor:#333333,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#222222,#333333,#555555'
                                                ),
                                                'offer_blog_earls_green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#C2AF2F,#CEBF59,#333333,#555555'
                                                ),
                                                'offer_blog_pompadour' => array(
                                                    'preset_name' => __('Pompadour', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#974772,template_titlecolor:#7D194F,related_title_color:#7D194F,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#7D194F,#974772,#333333,#555555'
                                                ),
                                                'offer_blog_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#333333,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#414C22,#67704E,#333333,#555555'
                                                ),
                                                'offer_blog_west-side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FDF6F1,template_ftcolor:#333333,template_fthovercolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E4802A,#E99955,#333333,#555555'
                                                ),
                                                'offer_blog_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#F5F7FB,template_ftcolor:#333333,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#333333,#555555'
                                                ),
                                            ),
                                            'overlay_horizontal' => array(
                                                'overlay_horizontal_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#000000,template_ftcolor:#e2112f,template_fthovercolor:#ffffff,template_titlecolor:#ffffff,related_title_color:#ffffff,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#000000,#e2112f,#ffffff,#333333'
                                                ),
                                                'overlay_horizontal_persian_red' => array(
                                                    'preset_name' => __('Persian Red', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#CC3333,template_ftcolor:#33cccc,template_fthovercolor:#ffffff,template_titlecolor:#3333cc,related_title_color:#ffffff,template_contentcolor:#ffffff,firstletter_contentcolor:#ffffff',
                                                    'display_value' => '#CC3333,#33cccc,#3333cc,#ffffff'
                                                ),
                                                'overlay_horizontal_dark_goldenrod' => array(
                                                    'preset_name' => __('Dark Goldenrod', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#b8860b,template_ftcolor:#0bb886,template_fthovercolor:#94b80b,template_titlecolor:#0b3db8,related_title_color:#0b3db8,template_contentcolor:#b8300b,firstletter_contentcolor:#b8300b',
                                                    'display_value' => '#b8860b,#0bb886,#0b3db8,#b8300b'
                                                ),
                                                'overlay_horizontal_deep_cerise' => array(
                                                    'preset_name' => __('Deep Cerise', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#da3287,template_ftcolor:#87da32,template_fthovercolor:#3287da,template_titlecolor:#3287da,related_title_color:#3287da,template_contentcolor:#32da85,firstletter_contentcolor:#32da85',
                                                    'display_value' => '#da3287,#87da32,#3287da,#32da85'
                                                ),
                                                'overlay_horizontal_rust' => array(
                                                    'preset_name' => __('Rust', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#a55d35,template_ftcolor:#35a55d,template_fthovercolor:#5d35a5,template_titlecolor:#333333,related_title_color:#333333,template_contentcolor:#ffffff,firstletter_contentcolor:#ffffff',
                                                    'display_value' => '#a55d35,#35a55d,#333333,#ffffff'
                                                ),
                                                'overlay_horizontal_blue' => array(
                                                    'preset_name' => __('Chetwode Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#666fb4,template_ftcolor:#6fb466,template_fthovercolor:#ffffff,template_titlecolor:#b4ab66,related_title_color:#b4ab66,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#666fb4,#6fb466,#b4ab66,#333333'
                                                ),
                                            ),
                                            'pretty' => array(
                                                'pretty_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#ff93a3,template_ftcolor:#999999,template_fthovercolor:#859f88,template_titlecolor:#859f88,related_title_color:#859f88,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#ff93a3,#859f88,#555555,#999999'
                                                ),
                                                'pretty_sky_blue' => array(
                                                    'preset_name' => __('Sky Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#DAEBFF,template_ftcolor:#888888,template_fthovercolor:#00809D,template_titlecolor:#00809D,related_title_color:#00809D,template_contentcolor:#484848,firstletter_contentcolor:#484848',
                                                    'display_value' => '#DAEBFF,#00809D,#484848,#888888'
                                                ),
                                                'pretty_lite_green' => array(
                                                    'preset_name' => __('Lite Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_color:#C3F3DD,template_ftcolor:#888888,template_fthovercolor:#0ef58d,template_titlecolor:#0ef58d,related_title_color:#0ef58d,template_contentcolor:#484848,firstletter_contentcolor:#484848',
                                                    'display_value' => '#C3F3DD,#0ef58d,#484848,#888888'
                                                ),
                                            ),
                                            'region' => array(
                                                'region_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#0E7699,template_fthovercolor:#333333,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E7699,#222222,#333333,#555555'
                                                ),
                                                'region_regal-blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#333333,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#14375F,#435F7F,#333333,#555555'
                                                ),
                                                'region_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#333333,template_fthovercolor:#ED4961,template_titlecolor:#E81B3A,related_title_color:#E81B3A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#E81B3A,#ED4961,#333333,#555555'
                                                ),
                                                'region_lemon_ginger' => array(
                                                    'preset_name' => __('Lemon Ginger', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#333333,template_fthovercolor:#A39D5A,template_titlecolor:#8C8431,related_title_color:#8C8431,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#8C8431,#A39D5A,#333333,#555555'
                                                ),
                                                'region_fun_green' => array(
                                                    'preset_name' => __('Fun Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#333333,template_fthovercolor:#3E8563,template_titlecolor:#0E663C,related_title_color:#0E663C,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#0E663C,#3E8563,#333333,#555555'
                                                ),
                                                'region_toddy' => array(
                                                    'preset_name' => __('Toddy', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#333333,template_fthovercolor:#BE9055,template_titlecolor:#AE742A,related_title_color:#AE742A,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#AE742A,#BE9055,#333333,#555555'
                                                ),
                                            ),
                                            'sharpen' => array(
                                                'sharpen_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ffffff,template_ftcolor:#f5ab35,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#f5ab35,#ffffff,#4c4c4c,#808080'
                                                ),
                                                'sharpen_pink' => array(
                                                    'preset_name' => __('Pink', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FEF5F8,template_ftcolor:#e21130,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#e21130,#FEF5F8,#4c4c4c,#808080'
                                                ),
                                                'sharpen_solitude' => array(
                                                    'preset_name' => __('Solitude', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#FFF3E5,template_ftcolor:#FF8A00,template_fthovercolor:#4c4c4c,template_titlecolor:#4c4c4c,related_title_color:#4c4c4c,template_contentcolor:#808080,firstletter_contentcolor:#808080',
                                                    'display_value' => '#FF8A00,#FFF3E5,#4c4c4c,#808080'
                                                ),
                                            ),
                                            'spektrum' => array(
                                                'spektrum_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#0E7699,template_fthovercolor:#555555,template_titlecolor:#222222,related_title_color:#222222,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#222222,#555555,#888888'
                                                ),
                                                'spektrum_crimson' => array(
                                                    'preset_name' => __('Crimson', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E21130,#E84159,#555555,#888888'
                                                ),
                                                'spektrum_bronzetone' => array(
                                                    'preset_name' => __('Bronzetone', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#67704E,template_titlecolor:#414C22,related_title_color:#414C22,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#414C22,#67704E,#555555,#888888'
                                                ),
                                                'spektrum_west_side' => array(
                                                    'preset_name' => __('West Side', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#E99955,template_titlecolor:#E4802A,related_title_color:#E4802A,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E4802A,#E99955,#555555,#888888'
                                                ),
                                                'spektrum_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#93A564,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#788F3D,#93A564,#555555,#888888'
                                                ),
                                                'spektrum_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_ftcolor:#555555,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#555555,#888888'
                                                ),
                                            ),
                                            'story' => array(
                                                'story_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#4458c9,template_color:#b00dd8,template_alternative_color:#b00dd8,story_startup_border_color:#ffffff,story_startup_background:#85e71c,story_startup_text_color:#333333,story_ending_background:#ade175,story_ending_text_color:#333333,template_ftcolor:#4458c9,template_fthovercolor:#2b2b2b,template_titlecolor:#707070,related_title_color:#707070,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#4458c9,#b00dd8,#85e71c,#333333'
                                                ),
                                                'story_goldenrod' => array(
                                                    'preset_name' => __('Goldenrod', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#daa520,template_color:#2055da,template_alternative_color:#d23582,story_startup_border_color:#da4820,story_startup_background:#da4820,story_startup_text_color:#ffffff,story_ending_background:#da4820,story_ending_text_color:#ffffff,template_ftcolor:#da4820,template_fthovercolor:#2b2b2b,template_titlecolor:#707070,related_title_color:#707070,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#daa520,#2055da,#da4820,#333333'
                                                ),
                                                'story_radical_red' => array(
                                                    'preset_name' => __('Radical Red', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_bgcolor:#ff355e,template_color:#355eff,template_alternative_color:#f18547,story_startup_border_color:#5d8a99,story_startup_background:#5d8a99,story_startup_text_color:#ffffff,story_ending_background:#5d8a99,story_ending_text_color:#ffffff,template_ftcolor:#5d8a99,template_fthovercolor:#2b2b2b,template_titlecolor:#707070,related_title_color:#707070,template_contentcolor:#666666,firstletter_contentcolor:#666666',
                                                    'display_value' => '#ff355e,#355eff,#5d8a99,#333333'
                                                )
                                            ),
                                            'tagly' => array(
                                                'tagly_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#d4c6a8,template_ftcolor:#b79a5e,template_fthovercolor:#d4c6a8,template_titlecolor:#333333,related_title_color:#333333,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#b79a5e,#d4c6a8,#333333,#555555'
                                                ),
                                                'tagly_crimson' => array(
                                                    'preset_name' => __('Crimson', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#E84159,template_ftcolor:#555555,template_fthovercolor:#E84159,template_titlecolor:#E21130,related_title_color:#E21130,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#E21130,#E84159,#555555,#888888'
                                                ),
                                                'tagly_cerulean' => array(
                                                    'preset_name' => __('Cerulean', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#3E91AD,template_ftcolor:#555555,template_fthovercolor:#3E91AD,template_titlecolor:#0E7699,related_title_color:#0E7699,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#0E7699,#3E91AD,#555555,#888888'
                                                ),
                                                'tagly_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#93A564,template_ftcolor:#555555,template_fthovercolor:#93A564,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#788F3D,#93A564,#555555,#888888'
                                                ),
                                                'tagly_ce_soir' => array(
                                                    'preset_name' => __('Ce Soir', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#A381BB,template_ftcolor:#555555,template_fthovercolor:#A381BB,template_titlecolor:#8C62AA,related_title_color:#8C62AA,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#8C62AA,#A381BB,#555555,#888888'
                                                ),
                                                'tagly_earls-green' => array(
                                                    'preset_name' => __('Earls Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'template_color:#CEBF59,template_ftcolor:#555555,template_fthovercolor:#CEBF59,template_titlecolor:#C2AF2F,related_title_color:#C2AF2F,template_contentcolor:#888888,firstletter_contentcolor:#888888',
                                                    'display_value' => '#C2AF2F,#CEBF59,#555555,#888888'
                                                ),
                                            ),
                                            'timeline' => array(
                                                'timeline_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#0099CB,template_color:#0099CB,template_ftcolor:#0099CB,template_fthovercolor:#333333,template_titlecolor:#0099CB,related_title_color:#222222,template_titlebackcolor:#E6F5FA,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#0099CB,#005B79,#222222,#333333'
                                                ),
                                                'timeline_venetian_red' => array(
                                                    'preset_name' => __('Venetian Red', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#414a54,template_color:#CC0001,template_ftcolor:#f15f74,template_fthovercolor:#444444,template_titlecolor:#f15f74,related_title_color:#f15f74,template_titlebackcolor:#ffffff,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#CC0001,#444444,#f15f74,#333333'
                                                ),
                                                'timeline_pink' => array(
                                                    'preset_name' => __('Dark Sea Green', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#f15f74,template_color:#8FBC8F,template_ftcolor:#f15f74,template_fthovercolor:#444444,template_titlecolor:#475E47,related_title_color:#475E47,template_titlebackcolor:#F6F8F5,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#8FBC8F,#475E47,#f15f74,#333333'
                                                ),
                                                'timeline_dark_orchid' => array(
                                                    'preset_name' => __('Dark Orchid', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#9A33CC,template_color:#9A33CC,template_ftcolor:#CC9932,template_fthovercolor:#444444,template_titlecolor:#5B1E7A,related_title_color:#5B1E7A,template_titlebackcolor:#F5EAFA,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#9A33CC,#5B1E7A,#CC9932,#333333'
                                                ),
                                                'timeline_dark_orange' => array(
                                                    'preset_name' => __('Dark Orange', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#FF8A00,template_color:#FF8A00,template_ftcolor:#0073FF,template_fthovercolor:#444444,template_titlecolor:#7F4600,related_title_color:#7F4600,template_titlebackcolor:#FFF3E5,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#FF8A00,#7F4600,#0073FF,#333333'
                                                ),
                                                'timeline_venetian_red' => array(
                                                    'preset_name' => __('Venetian Red', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'displaydate_backcolor:#CC0001,template_color:#C80815,template_ftcolor:#08C8BB,template_fthovercolor:#444444,template_titlecolor:#78040C,related_title_color:#78040C,template_titlebackcolor:#FAE4E6,template_contentcolor:#333333,firstletter_contentcolor:#333333',
                                                    'display_value' => '#C80815,#78040C,#08C8BB,#333333'
                                                ),
                                            ),
                                            'winter' => array(
                                                'winter_default' => array(
                                                    'preset_name' => __('Default', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#e7492f,template_ftcolor:#37aece,template_fthovercolor:#444444,template_titlecolor:#444444,related_title_color:#444444,template_contentcolor:#555555,firstletter_contentcolor:#555555',
                                                    'display_value' => '#e7492f,#37aece,#444444,#555555'
                                                ),
                                                'winter_wasabi' => array(
                                                    'preset_name' => __('Wasabi', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#93A564,template_ftcolor:#555555,template_fthovercolor:#93A564,template_titlecolor:#788F3D,related_title_color:#788F3D,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#788F3D,#93A564,#555555,#999999'
                                                ),
                                                'winter_yonder' => array(
                                                    'preset_name' => __('Yonder', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#8BA3CE,template_ftcolor:#555555,template_fthovercolor:#8BA3CE,template_titlecolor:#6E8CC2,related_title_color:#6E8CC2,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#6E8CC2,#8BA3CE,#555555,#999999'
                                                ),
                                                'winter_regal_blue' => array(
                                                    'preset_name' => __('Regal Blue', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#435F7F,template_ftcolor:#555555,template_fthovercolor:#435F7F,template_titlecolor:#14375F,related_title_color:#14375F,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#14375F,#435F7F,#555555,#999999'
                                                ),
                                                'winter_buttercup' => array(
                                                    'preset_name' => __('Buttercup', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#E5A452,template_ftcolor:#555555,template_fthovercolor:#E5A452,template_titlecolor:#DF8D27,related_title_color:#DF8D27,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#DF8D27,#E5A452,#555555,#999999'
                                                ),
                                                'winter_alizarin' => array(
                                                    'preset_name' => __('Alizarin', BLOGDESIGNERPRO_TEXTDOMAIN),
                                                    'preset_value' => 'winter_category_color:#EE4861,template_ftcolor:#555555,template_fthovercolor:#EE4861,template_titlecolor:#EA1A3A,related_title_color:#EA1A3A,template_contentcolor:#999999,firstletter_contentcolor:#999999',
                                                    'display_value' => '#EA1A3A,#EE4861,#555555,#999999'
                                                ),
                                            ),
                                        );
                                        foreach ($template_color_preset as $key => $single_template) {
                                            ?>
                                            <div class="controls_preset <?php echo $key; ?>" style="display:none;">
                                                <?php foreach ($single_template as $name => $value) { ?>
                                                    <div class="color-option preset<?php
                                                    if ($bdp_color_preset == $name) {
                                                        echo ' color_preset_selected';
                                                    }
                                                    ?>" data-value="<?php echo $value['preset_value']; ?>">
                                                        <label>
                                                            <input class="of-radio-color" type="radio" name="bdp_color_preset" value="<?php echo $name; ?>" <?php checked($bdp_color_preset, $name); ?>>
                                                            <?php echo $value['preset_name']; ?>
                                                        </label>
                                                        <?php bdp_admin_color_preset($value['display_value']); ?>
                                                    </div>
                                                <?php }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter single layout name', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Single Layout Name', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="single_layout_name" id="single_layout_name" value="<?php echo $single_template_name; ?>" placeholder="<?php esc_attr_e('Enter single layout name', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e("Apply plugin's single post layout design to single post", BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Override Single Post Design', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <label>
                                            <input id="override_single" name="override_single" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['override_single'])) {
                                                checked(1, $bdp_settings['override_single']);
                                            }
                                            ?> />
                                        </label>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="override-single-design-table">
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select single post override type', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Single Post Override Type', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $bdp_single_type = '';
                                        if (isset($bdp_settings['bdp_single_type'])) {
                                            $bdp_single_type = $bdp_settings['bdp_single_type'];
                                        }
                                        if ($custom_single_type == 'all') {
                                            $all_setting = '';
                                        } else {
                                            $all_setting = bdp_get_all_single_template_settings();
                                        }
                                        ?>
                                        <select id="bdp_single_type" name="bdp_single_type">
                                            <option value="all" <?php
                                            if ($all_setting) {
                                                echo "disabled='disabled'";
                                            }
                                            ?> <?php echo selected('all', $bdp_single_type); ?>><?php _e('All Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="category" <?php echo selected('category', $bdp_single_type); ?>><?php _e('Category Wise', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="tag" <?php echo selected('tag', $bdp_single_type); ?>><?php _e('Tag Wise', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                        <div class="bdp-setting-description">
                                            <b class="note"><?php _e('Note:', BLOGDESIGNERPRO_TEXTDOMAIN); ?></b>
                                            <?php _e('If you select category/tag post override type, you must have to select category/tag type to show post.', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="single_category_list_tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select post categories', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Post Categories', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $template_category = isset($bdp_settings['template_category']) ? $bdp_settings['template_category'] : array();
                                        $categories = get_categories(array('child_of' => '', 'hide_empty' => 1));
                                        $db_categories = $wpdb->get_results('SELECT sub_categories FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "category"');
                                        $db_category_list = array();
                                        if ($db_categories) {
                                            foreach ($db_categories as $db_category) {
                                                $sub_list = $db_category->sub_categories;
                                                if ($sub_list) {
                                                    $db_category_ids = explode(',', $sub_list);
                                                    foreach ($db_category_ids as $db_category_id) {
                                                        $db_category_list[] = $db_category_id;
                                                    }
                                                }
                                            }
                                        }
                                        $final_cat = array_diff($db_category_list, $template_category);
                                        ?>
                                        <select data-placeholder="<?php esc_attr_e('Choose Post Categories', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" class="chosen-select" multiple style="width:220px;" name="template_category[]" id="template_category"><?php foreach ($categories as $categoryObj): ?>
                                                <option value="<?php echo $categoryObj->term_id; ?>" <?php
                                                if (@in_array($categoryObj->term_id, $template_category)) {
                                                    echo 'selected="selected"';
                                                }
                                                if (in_array($categoryObj->term_id, $final_cat)) {
                                                    echo 'disabled="disabled"';
                                                }
                                                ?>><?php echo $categoryObj->name; ?></option><?php endforeach; ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr class="single_tag_list_tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select post tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Post Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $template_tags = isset($bdp_settings['template_tags']) ? $bdp_settings['template_tags'] : array();
                                        $tags = get_tags();
                                        $db_tags = $wpdb->get_results('SELECT sub_categories FROM ' . $wpdb->prefix . 'bdp_single_layouts WHERE single_template = "tag"');
                                        $db_tag_list = array();
                                        if ($db_tags) {
                                            foreach ($db_tags as $db_tag) {
                                                $sub_list = $db_tag->sub_categories;
                                                if ($sub_list) {
                                                    $db_tag_ids = explode(',', $sub_list);
                                                    foreach ($db_tag_ids as $db_tag_id) {
                                                        $db_tag_list[] = $db_tag_id;
                                                    }
                                                }
                                            }
                                        }
                                        $final_tag = array_diff($db_tag_list, $template_tags);
                                        ?>
                                        <select data-placeholder="<?php esc_attr_e('Choose Post Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" class="chosen-select" multiple style="width:220px;" name="template_tags[]" id="template_tags">
                                            <?php foreach ($tags as $tag) : ?>
                                                <option value="<?php echo $tag->term_id; ?>" <?php
                                                if (@in_array($tag->term_id, $template_tags)) {
                                                    echo 'selected="selected"';
                                                }
                                                if (in_array($tag->term_id, $final_tag)) {
                                                    echo 'disabled="disabled"';
                                                }
                                                ?>><?php echo $tag->name; ?></option>
                                                    <?php endforeach; ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr class="single_all_post_tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select post from available posts for single post layout', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $template_posts = isset($bdp_settings['template_posts']) ? $bdp_settings['template_posts'] : array();
                                        $db_posts = $wpdb->get_results('SELECT single_post_id FROM ' . $wpdb->prefix . 'bdp_single_layouts');
                                        $db_posts_list = array();
                                        if ($db_posts) {
                                            foreach ($db_posts as $db_post) {
                                                $sub_list = $db_post->single_post_id;
                                                if ($sub_list) {
                                                    $db_post_ids = explode(',', $sub_list);
                                                    foreach ($db_post_ids as $db_post_id) {
                                                        $db_posts_list[] = $db_post_id;
                                                    }
                                                }
                                            }
                                        }
                                        $final_posts = array_diff($db_posts_list, $template_posts);
                                        if ($bdp_single_type == 'tag') {
                                            $tag_ids = isset($bdp_settings['template_tags']) ? $bdp_settings['template_tags'] : array();
                                            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc', 'tag__in' => $tag_ids);
                                        } else if ($bdp_single_type == 'category') {
                                            $cat_ids = isset($bdp_settings['template_category']) ? $bdp_settings['template_category'] : array();
                                            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc', 'category__in' => $cat_ids);
                                        } else {
                                            $args = array('posts_per_page' => -1, 'post_type' => 'post', 'orderby' => 'date', 'order' => 'desc');
                                        }
                                        $allposts = get_posts($args);
                                        if ($allposts) {
                                            ?>
                                            <select data-placeholder="<?php esc_attr_e('Choose Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" class="chosen-select" multiple style="width:220px;" name="template_posts[]" id="template_posts">
                                                <?php
                                                foreach ($allposts as $single_post) : setup_postdata($single_post);
                                                    ?>
                                                    <option value="<?php echo $single_post->ID; ?>"
                                                    <?php
                                                    if (@in_array($single_post->ID, $bdp_settings['template_posts'])) {
                                                        echo 'selected="selected"';
                                                    }
                                                    if (in_array($single_post->ID, $final_posts)) {
                                                        echo 'disabled="disabled"';
                                                    }
                                                    ?>><?php echo $single_post->post_title; ?>
                                                    </option>
                                                    <?php
                                                endforeach;
                                                wp_reset_postdata();
                                                ?>
                                            </select>
                                            <div class="bdp-setting-description">
                                                <b class="note"><?php _e('Note:', BLOGDESIGNERPRO_TEXTDOMAIN); ?></b>
                                                <?php _e('Default All Posts Selected', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                            </div>
                                            <?php
                                        } else {
                                            _e('No posts found', BLOGDESIGNERPRO_TEXTDOMAIN);
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Title ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_title = isset($bdp_settings['display_title']) ? $bdp_settings['display_title'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_title buttonset">
                                            <input id="display_title_0" name="display_title" type="radio" value="0" <?php echo checked(0, $display_title); ?> />
                                            <label for="display_title_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_title_1" name="display_title" type="radio" value="1" <?php echo checked(1, $display_title); ?>/>
                                            <label for="display_title_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post category', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Category ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_category = isset($bdp_settings['display_category']) ? $bdp_settings['display_category'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author buttonset">
                                            <input id="display_category_0" name="display_category" type="radio" value="0" <?php echo checked(0, $display_category); ?> />
                                            <label for="display_category_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_category_1" name="display_category" type="radio" value="1" <?php echo checked(1, $display_category); ?>/>
                                            <label for="display_category_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="disable_link">
                                            <input id="disable_link_category" name="disable_link_category" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['disable_link_category'])) {
                                                checked(1, $bdp_settings['disable_link_category']);
                                            }
                                            ?> /> <?php _e('Disable Link for Categories', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post tag', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Tag ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_tag = isset($bdp_settings['display_tag']) ? $bdp_settings['display_tag'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author buttonset">
                                            <input id="display_tag_0" name="display_tag" type="radio" value="0" <?php checked(0, $display_tag); ?> />
                                            <label for="display_tag_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_tag_1" name="display_tag" type="radio" value="1" <?php checked(1, $display_tag); ?>/>
                                            <label for="display_tag_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="disable_link">
                                            <input id="disable_link_tag" name="disable_link_tag" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['disable_link_tag'])) {
                                                checked(1, $bdp_settings['disable_link_tag']);
                                            }
                                            ?> /> <?php _e('Disable Link for Tags', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post author', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Author ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_author = isset($bdp_settings['display_author']) ? $bdp_settings['display_author'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author buttonset">
                                            <input id="display_author_0" name="display_author" type="radio" value="0" <?php checked(0, $display_author); ?> />
                                            <label for="display_author_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_author_1" name="display_author" type="radio" value="1"  <?php checked(1, $display_author); ?>/>
                                            <label for="display_author_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="disable_link">
                                            <input id="disable_link_author" name="disable_link_author" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['disable_link_author'])) {
                                                checked(1, $bdp_settings['disable_link_author']);
                                            }
                                            ?> />
                                                   <?php _e('Disable Link for Author', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr class="bdp_single_post_published_year">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post published year', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Published Year', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_single_story_year = 1;
                                        if (isset($bdp_settings['display_single_story_year']) && $bdp_settings['display_single_story_year'] != '') {
                                            $display_single_story_year = $bdp_settings['display_single_story_year'];
                                        }
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author buttonset">
                                            <input id="display_single_story_year_0" name="display_single_story_year" type="radio" value="0" <?php checked(0, $display_single_story_year); ?> />
                                            <label for="display_single_story_year_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_single_story_year_1" name="display_single_story_year" type="radio" value="1"  <?php checked(1, $display_single_story_year); ?>/>
                                            <label for="display_single_story_year_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post published date', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Published Date ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_date = isset($bdp_settings['display_date']) ? $bdp_settings['display_date'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_date buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_date_0" name="display_date" type="radio" value="0" <?php checked(0, $display_date); ?> />
                                            <label for="display_date_0" <?php checked(0, $display_date); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_date_1" name="display_date" type="radio" value="1" <?php checked(1, $display_date); ?>/>
                                            <label for="display_date_1" <?php checked(1, $display_date); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="disable_link">
                                            <input id="disable_link_date" name="disable_link_date" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['disable_link_date'])) {
                                                checked(1, $bdp_settings['disable_link_date']);
                                            }
                                            ?> />
                                                   <?php _e('Disable Link for Publish Date', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post comment', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Comments ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_comment = isset($bdp_settings['display_comment']) ? $bdp_settings['display_comment'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_comment buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_comment_0" name="display_comment" type="radio" value="0" <?php checked(0, $display_comment); ?> />
                                            <label for="display_comment_0" <?php checked(0, $display_comment); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_comment_1" name="display_comment" type="radio" value="1" <?php checked(1, $display_comment); ?>/>
                                            <label for="display_comment_1" <?php checked(1, $display_comment); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="disable_link">
                                            <input id="disable_link_comment" name="disable_link_comment" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['disable_link_comment'])) {
                                                checked(1, $bdp_settings['disable_link_comment']);
                                            }
                                            ?> />
                                                   <?php _e('Disable Link for Comments Form', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post thumbnail', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Thumbnail  ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_thumbnail = isset($bdp_settings['display_thumbnail']) ? $bdp_settings['display_thumbnail'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_comment buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_thumbnail_0" name="display_thumbnail" type="radio" value="0" <?php checked(0, $display_thumbnail); ?> />
                                            <label for="display_thumbnail_0" <?php checked(0, $display_thumbnail); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_thumbnail_1" name="display_thumbnail" type="radio" value="1" <?php checked(1, $display_thumbnail); ?>/>
                                            <label for="display_thumbnail_1" <?php checked(1, $display_thumbnail); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="display-postlike">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post like', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Like ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $display_postlike = isset($bdp_settings['display_postlike']) ? $bdp_settings['display_postlike'] : '0'; ?>
                                        <fieldset class="buttonset">
                                            <input id="display_postlike_0" name="display_postlike" type="radio" value="0" <?php echo checked(0, $display_postlike); ?> />
                                            <label for="display_postlike_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_postlike_1" name="display_postlike" type="radio" value="1" <?php echo checked(1, $display_postlike); ?>/>
                                            <label for="display_postlike_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post views', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Views ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $display_post_views = 0;
                                        if (isset($bdp_settings['display_post_views'])) {
                                            $display_post_views = $bdp_settings['display_post_views'];
                                        }
                                        ?>
                                        <fieldset class="bdp-social-size buttonset buttonset-hide green" data-hide='1'>
                                            <input id="display_post_views_0" name="display_post_views" type="radio" value="0" <?php checked(0, $display_post_views); ?>/>
                                            <label id="bdp-options-button" for="display_post_views_0" <?php checked(0, $display_post_views); ?>><?php _e('Hide', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_post_views_1" name="display_post_views" type="radio" value="1" <?php checked(1, $display_post_views); ?> />
                                            <label id="bdp-options-button" for="display_post_views_1" <?php checked(1, $display_post_views); ?>><?php _e("Show Today's View", BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_post_views_2" name="display_post_views" type="radio" value="2" <?php checked(2, $display_post_views); ?> />
                                            <label id="bdp-options-button" for="display_post_views_2" <?php checked(2, $display_post_views); ?>><?php _e('Show All Views', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="override-single-design-table">
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Add custom css for single post layout', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Custom CSS', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <textarea placeholder=".class_name{ color:#ffffff }" name="custom_css" id="custom_css"><?php if (isset($bdp_settings['custom_css'])) echo stripslashes($bdp_settings['custom_css']); ?></textarea>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsinglestandard" class="postbox postbox-with-fw-options" <?php echo $bdpstandard_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter main container class name', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Main Container Class Name', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $main_container_class = (isset($bdp_settings['main_container_class']) && $bdp_settings['main_container_class'] != '') ? $bdp_settings['main_container_class'] : ''; ?>
                                        <input type="text" name="main_container_class" id="main_container_class" value="<?php echo $main_container_class; ?>" placeholder="<?php esc_attr_e('Enter main container class name', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                                    </td>
                                </tr>
                                <tr class="single-background-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select single post background color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Background Color for Single Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_bgcolor" id="template_bgcolor" value="<?php echo isset($bdp_settings["template_bgcolor"]) ? $bdp_settings["template_bgcolor"] : '#fff'; ?>"/>
                                    </td>
                                </tr>
                                <tr class="blog-templatecolor-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select single post template color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Single Post Template Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_color" id="template_color" value="<?php echo isset($bdp_settings["template_color"]) ? $bdp_settings["template_color"] : '#000'; ?>"/>
                                    </td>
                                </tr>
                                <tr class="story-startup-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter story startup text', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Story Startup Text', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="story_startup_text" id="story_startup_text" value="<?php echo isset($bdp_settings["story_startup_text"]) ? $bdp_settings["story_startup_text"] : __('STARTUP', BLOGDESIGNERPRO_TEXTDOMAIN); ?>"/>
                                    </td>
                                </tr>
                                <tr class="story-startup-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select story startup background color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Story Startup Background Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="story_startup_background" id="story_startup_background"
                                               value="<?php echo isset($bdp_settings["story_startup_background"]) ? $bdp_settings["story_startup_background"] : '#ade175'; ?>"
                                               data-default-color="<?php echo isset($bdp_settings["story_startup_background"]) ? $bdp_settings["story_startup_background"] : '#ade175'; ?>"/>
                                    </td>
                                </tr>
                                <tr class="story-startup-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select story startup text color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Story Startup Text Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="story_startup_text_color" id="story_startup_text_color"
                                               value="<?php echo isset($bdp_settings["story_startup_text_color"]) ? $bdp_settings["story_startup_text_color"] : '#333'; ?>"
                                               data-default-color="<?php echo isset($bdp_settings["story_startup_text_color"]) ? $bdp_settings["story_startup_text_color"] : '#333'; ?>"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select link color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Choose Link Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_ftcolor" id="template_ftcolor"
                                               value="<?php echo isset($bdp_settings["template_ftcolor"]) ? $bdp_settings["template_ftcolor"] : ''; ?>"
                                               data-default-color="<?php echo isset($bdp_settings["template_ftcolor"]) ? $bdp_settings["template_ftcolor"] : ''; ?>"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select link hover color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Choose Link Hover Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_fthovercolor" id="template_fthovercolor"
                                               value="<?php if (isset($bdp_settings["template_fthovercolor"])) echo $bdp_settings["template_fthovercolor"]; ?>"
                                               data-default-color="<?php if (isset($bdp_settings["template_fthovercolor"])) echo $bdp_settings["template_fthovercolor"]; ?>"/>
                                    </td>
                                </tr>
                                <tr class="winter-category-back-color" style="display: none;">
                                    <td>
                                        <div class="bd-title-tooltip"><?php echo $winter_category_txt; ?></div>
                                        <?php echo $winter_category_txt; ?>
                                    </td>
                                    <td>
                                        <input type="text" name="winter_category_color" id="winter_category_color"
                                               value="<?php if (isset($bdp_settings["winter_category_color"])) echo $bdp_settings["winter_category_color"]; ?>"
                                               data-default-color="<?php if (isset($bdp_settings["winter_category_color"])) echo $bdp_settings["winter_category_color"]; ?>"/>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsingletitle" class="postbox postbox-with-fw-options" <?php echo $bdptitle_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select post title color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Post Title Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_titlecolor" id="template_titlecolor" value="<?php echo isset($bdp_settings["template_titlecolor"]) ? $bdp_settings["template_titlecolor"] : ''; ?>"/>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                        <h3 class="bdp-table-title"><?php _e('Typography Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></h3>
                        <div class="bdp-typography-wrapper">
                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select post title font family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Post Title Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <input type="hidden" name="template_titlefontface_font_type" id="template_titlefontface_font_type" value="<?php echo isset($bdp_settings['template_titlefontface_font_type']) ? $bdp_settings['template_titlefontface_font_type'] : 'Serif Fonts'; ?>">
                                    <div class="select-cover">
                                        <select name="template_titlefontface" id="template_titlefontface">
                                            <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <?php
                                            if (isset($bdp_settings['template_titlefontface']) && $bdp_settings['template_titlefontface'] != '') {
                                                $template_titlefontface = $bdp_settings['template_titlefontface'];
                                            } else {
                                                $template_titlefontface = '';
                                            }
                                            $old_version = '';
                                            $cnt = 0;
                                            foreach ($font_family as $key => $value) {
                                                if ($value['version'] != $old_version) {
                                                    if ($cnt > 0) {
                                                        echo '</optgroup>';
                                                    }
                                                    echo '<optgroup label="' . $value['version'] . '">';
                                                    $old_version = $value['version'];
                                                }
                                                echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                if ($template_titlefontface != '' && (str_replace('"', '', $template_titlefontface) == str_replace('"', '', $value['label']))) {
                                                    echo ' selected';
                                                }
                                                echo ">" . $value['label'] . "</option>";
                                                $cnt++;
                                            }
                                            if ($cnt == count($font_family)) {
                                                echo '</optgroup>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select post title font size', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Post Title Font Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php
                                        if (isset($bdp_settings['template_titlefontsize'])) {
                                            $template_titlefontsize = $bdp_settings['template_titlefontsize'];
                                        } else {
                                            $template_titlefontsize = 16;
                                        }
                                        ?>
                                        <div class="grid_col_space range_slider_fontsize" id="template_titlefontsizeInput" ></div>
                                        <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="template_titlefontsize" id="template_titlefontsize" value="<?php echo $template_titlefontsize; ?>" onkeypress="return isNumberKey(event)" /></div><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select font weight', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Font Weight', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_title_font_weight = isset($bdp_settings['template_title_font_weight']) ? $bdp_settings['template_title_font_weight'] : 'normal'; ?>
                                    <div class="select-cover">
                                        <select name="template_title_font_weight" id="template_title_font_weight">
                                            <option value="100" <?php selected($template_title_font_weight, 100); ?>>100</option>
                                            <option value="200" <?php selected($template_title_font_weight, 200); ?>>200</option>
                                            <option value="300" <?php selected($template_title_font_weight, 300); ?>>300</option>
                                            <option value="400" <?php selected($template_title_font_weight, 400); ?>>400</option>
                                            <option value="500" <?php selected($template_title_font_weight, 500); ?>>500</option>
                                            <option value="600" <?php selected($template_title_font_weight, 600); ?>>600</option>
                                            <option value="700" <?php selected($template_title_font_weight, 700); ?>>700</option>
                                            <option value="800" <?php selected($template_title_font_weight, 800); ?>>800</option>
                                            <option value="900" <?php selected($template_title_font_weight, 900); ?>>900</option>
                                            <option value="bold" <?php selected($template_title_font_weight, 'bold'); ?> ><?php _e('Bold', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="normal" <?php selected($template_title_font_weight, 'normal'); ?>><?php _e('Normal', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enter line height', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Line Height', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <div class="input-type-number">
                                        <input type="number" name="template_title_font_line_height" id="template_title_font_line_height" step="0.1" min="0" value="<?php echo isset($bdp_settings['template_title_font_line_height']) ? $bdp_settings['template_title_font_line_height'] : '1.5'; ?>" onkeypress="return isNumberKey(event)">
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enable/Disable italic font style', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Italic Font Style', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <input type="checkbox" name="template_title_font_italic" id="template_title_font_italic" value="1"
                                        <?php
                                        if (isset($bdp_settings['template_title_font_italic'])) {
                                            checked(1, $bdp_settings['template_title_font_italic']);
                                        }
                                        ?>>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select text transform style', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Text Transform', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_title_font_text_transform = isset($bdp_settings['template_title_font_text_transform']) ? $bdp_settings['template_title_font_text_transform'] : 'none'; ?>
                                    <div class="select-cover">
                                        <select name="template_title_font_text_transform" id="template_title_font_text_transform">
                                            <option <?php selected($template_title_font_text_transform, 'none'); ?> value="none"><?php _e('None', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_transform, 'capitalize'); ?> value="capitalize"><?php _e('Capitalize', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_transform, 'uppercase'); ?> value="uppercase"><?php _e('Uppercase', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_transform, 'lowercase'); ?> value="lowercase"><?php _e('Lowercase', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_transform, 'full-width'); ?> value="full-width"><?php _e('Full Width', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select text decoration', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Text Decoration', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_title_font_text_decoration = isset($bdp_settings['template_title_font_text_decoration']) ? $bdp_settings['template_title_font_text_decoration'] : 'none'; ?>
                                    <div class="select-cover">
                                        <select name="template_title_font_text_decoration" id="template_title_font_text_decoration">
                                            <option <?php selected($template_title_font_text_decoration, 'none'); ?> value="none"><?php _e('None', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_decoration, 'underline'); ?> value="underline"><?php _e('Underline', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_decoration, 'overline'); ?> value="overline"><?php _e('Overline', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_title_font_text_decoration, 'line-through'); ?> value="line-through"><?php _e('Line Through', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enter letter spacing', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Letter Spacing', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <div class="input-type-number">
                                        <input type="number" name="template_title_font_letter_spacing" id="template_title_font_letter_spacing" step="1" min="0" value="<?php echo isset($bdp_settings['template_title_font_letter_spacing']) ? $bdp_settings['template_title_font_letter_spacing'] : '0'; ?>" onkeypress="return isNumberKey(event)">
                                    </div>
                                    <?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="bdpsingleconent" class="postbox postbox-with-fw-options bdp-content-setting1" <?php echo $bdpcontent_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr class="content-firstletter-tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable first letter of post content as big one', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('First letter of post content as big one', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td> <label>
                                            <input id="firstletter_big" name="firstletter_big" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['firstletter_big'])) {
                                                checked(1, $bdp_settings['firstletter_big']);
                                            }
                                            ?> />
                                        </label>
                                    </td>
                                </tr>
                                <tr class="firstletter-setting">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter font size for first letter of post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('First letter of Post Content Font Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['firstletter_fontsize']) && $bdp_settings['firstletter_fontsize'] != "") {
                                            $firstletter_fontsize = $bdp_settings['firstletter_fontsize'];
                                        } else {
                                            $firstletter_fontsize = 35;
                                        }
                                        ?>
                                        <div class="grid_col_space range_slider_fontsize" id="firstletter_fontsize_slider"></div>
                                        <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="firstletter_fontsize" id="firstletter_fontsize" value="<?php echo $firstletter_fontsize; ?>" onkeypress="return isNumberKey(event)" /></div>
                                    </td>
                                </tr>
                                <tr class="firstletter-setting">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select font family for first letter of post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('First letter of Post Content Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['firstletter_font_family']) && $bdp_settings['firstletter_font_family'] != '') {
                                            $firstletter_font_family = $bdp_settings['firstletter_font_family'];
                                        } else {
                                            $firstletter_font_family = '';
                                        }
                                        ?>
                                        <div class="typo-field">
                                            <input type="hidden" id="firstletter_font_family_font_type" name="firstletter_font_family_font_type" value="<?php echo isset($bdp_settings['firstletter_font_family_font_type']) ? $bdp_settings['firstletter_font_family_font_type'] : '' ?>">
                                            <select name="firstletter_font_family" id="firstletter_font_family">
                                                <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <?php
                                                $old_version = '';
                                                $cnt = 0;
                                                foreach ($font_family as $key => $value) {
                                                    if ($value['version'] != $old_version) {
                                                        if ($cnt > 0) {
                                                            echo '</optgroup>';
                                                        }
                                                        echo '<optgroup label="' . $value['version'] . '">';
                                                        $old_version = $value['version'];
                                                    }
                                                    echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                    if ($firstletter_font_family != '' && (str_replace('"', '', $firstletter_font_family) == str_replace('"', '', $value['label']))) {
                                                        echo ' selected';
                                                    }
                                                    echo ">" . $value['label'] . "</option>";
                                                    $cnt++;
                                                }
                                                if ($cnt == count($font_family)) {
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="firstletter-setting">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select color for sirst letter of post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('First letter of Post Content Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings["firstletter_contentcolor"])) {
                                            $firstletter_contentcolor = $bdp_settings["firstletter_contentcolor"];
                                        } else {
                                            $firstletter_contentcolor = '#000000';
                                        }
                                        ?>
                                        <input type="text" name="firstletter_contentcolor" id="firstletter_contentcolor" value="<?php echo $firstletter_contentcolor; ?>"/>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select color of post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Post Content Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="template_contentcolor" id="template_contentcolor" value="<?php echo isset($bdp_settings["template_contentcolor"]) ? $bdp_settings["template_contentcolor"] : ''; ?>"/>
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <h3 class="bdp-table-title"><?php _e('Typography Settings', BLOGDESIGNERPRO_TEXTDOMAIN); ?></h3>
                        <div class="bdp-typography-wrapper">
                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select font family for post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Post Content Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php
                                    $template_contentfontface = '';
                                    if (isset($bdp_settings['template_contentfontface'])) {
                                        $template_contentfontface = $bdp_settings['template_contentfontface'];
                                    }
                                    ?>
                                    <div class="typo-field">
                                        <input type="hidden" name="template_contentfontface_font_type" id="template_contentfontface_font_type" value="<?php echo isset($bdp_settings['template_contentfontface_font_type']) ? $bdp_settings['template_contentfontface_font_type'] : 'Serif Fonts'; ?>">
                                        <div class="select-cover">
                                            <select name="template_contentfontface" id="template_contentfontface">
                                                <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <?php
                                                $old_version = '';
                                                $cnt = 0;
                                                foreach ($font_family as $key => $value) {
                                                    if ($value['version'] != $old_version) {
                                                        if ($cnt > 0) {
                                                            echo '</optgroup>';
                                                        }
                                                        echo '<optgroup label="' . $value['version'] . '">';
                                                        $old_version = $value['version'];
                                                    }
                                                    echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                    if ($template_contentfontface != '' && (str_replace('"', '', $template_contentfontface) == str_replace('"', '', $value['label']))) {
                                                        echo ' selected';
                                                    }
                                                    echo ">" . $value['label'] . "</option>";
                                                    $cnt++;
                                                }
                                                if ($cnt == count($font_family)) {
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select font size of post content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Post Content Font Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php
                                    if (isset($bdp_settings["content_fontsize"])) {
                                        $content_fontsize = $bdp_settings["content_fontsize"];
                                    } else {
                                        $content_fontsize = 15;
                                    }
                                    ?>
                                    <div class="grid_col_space range_slider_fontsize" id="content_fontsize_slider" data-value="<?php echo $content_fontsize; ?>" ></div>
                                    <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="content_fontsize" id="content_fontsize" value="<?php echo $content_fontsize; ?>" onkeypress="return isNumberKey(event)" /></div><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select font weight', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Font Weight', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_content_font_weight = isset($bdp_settings['template_content_font_weight']) ? $bdp_settings['template_content_font_weight'] : 'normal'; ?>
                                    <div class="select-cover">
                                        <select name="template_content_font_weight" id="template_content_font_weight">
                                            <option value="100" <?php selected($template_content_font_weight, 100); ?>>100</option>
                                            <option value="200" <?php selected($template_content_font_weight, 200); ?>>200</option>
                                            <option value="300" <?php selected($template_content_font_weight, 300); ?>>300</option>
                                            <option value="400" <?php selected($template_content_font_weight, 400); ?>>400</option>
                                            <option value="500" <?php selected($template_content_font_weight, 500); ?>>500</option>
                                            <option value="600" <?php selected($template_content_font_weight, 600); ?>>600</option>
                                            <option value="700" <?php selected($template_content_font_weight, 700); ?>>700</option>
                                            <option value="800" <?php selected($template_content_font_weight, 800); ?>>800</option>
                                            <option value="900" <?php selected($template_content_font_weight, 900); ?>>900</option>
                                            <option value="bold" <?php selected($template_content_font_weight, 'bold'); ?> ><?php _e('Bold', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="normal" <?php selected($template_content_font_weight, 'normal'); ?>><?php _e('Normal', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enter line height', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Line Height', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <div class="input-type-number">
                                        <input type="number" name="template_content_font_line_height" id="template_content_font_line_height" step="0.1" min="0" value="<?php echo isset($bdp_settings['template_content_font_line_height']) ? $bdp_settings['template_content_font_line_height'] : '1.5'; ?>" onkeypress="return isNumberKey(event)">
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enable/Disable italic font style', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Italic Font Style', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <input type="checkbox" name="template_content_font_italic" id="template_content_font_italic" value="1"
                                    <?php
                                    if (isset($bdp_settings['template_content_font_italic'])) {
                                        checked(1, $bdp_settings['template_content_font_italic']);
                                    }
                                    ?>>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select text transform', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Text Transform', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_content_font_text_transform = isset($bdp_settings['template_content_font_text_transform']) ? $bdp_settings['template_content_font_text_transform'] : 'none'; ?>
                                    <div class="select-cover">
                                        <select name="template_content_font_text_transform" id="template_content_font_text_transform">
                                            <option <?php selected($template_content_font_text_transform, 'none'); ?> value="none"><?php _e('None', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_transform, 'capitalize'); ?> value="capitalize"><?php _e('Capitalize', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_transform, 'uppercase'); ?> value="uppercase"><?php _e('Uppercase', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_transform, 'lowercase'); ?> value="lowercase"><?php _e('Lowercase', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_transform, 'full-width'); ?> value="full-width"><?php _e('Full Width', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Select text decoration option', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Text Decoration', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <?php $template_content_font_text_decoration = isset($bdp_settings['template_content_font_text_decoration']) ? $bdp_settings['template_content_font_text_decoration'] : 'none'; ?>
                                    <div class="select-cover">
                                        <select name="template_content_font_text_decoration" id="template_content_font_text_decoration">
                                            <option <?php selected($template_content_font_text_decoration, 'none'); ?> value="none"><?php _e('None', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_decoration, 'underline'); ?> value="underline"><?php _e('Underline', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_decoration, 'overline'); ?> value="overline"><?php _e('Overline', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($template_content_font_text_decoration, 'line-through'); ?> value="line-through"><?php _e('Line Through', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="bdp-typography-cover">
                                <div class="bdp-typography-lable">
                                    <div class="bd-title-tooltip"><?php _e('Enter letter spacing', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Letter Spacing', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                                <div class="bdp-typography-content">
                                    <div class="input-type-number">
                                        <input type="number" name="template_content_font_letter_spacing" id="template_content_font_letter_spacing" step="1" min="0" value="<?php echo isset($bdp_settings['template_content_font_letter_spacing']) ? $bdp_settings['template_content_font_letter_spacing'] : '0'; ?>" onkeypress="return isNumberKey(event)">
                                    </div>
                                    <?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="bdpsinglemedia" class="postbox postbox-with-fw-options bdp-content-setting1" <?php echo $bdpmedia_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr class="bdp_single_custom_media_selection">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select size of post media', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Post Media Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <select id="bdp_media_size" name="bdp_media_size">
                                            <option value="full" <?php echo (isset($bdp_settings['bdp_media_size']) && $bdp_settings['bdp_media_size'] == 'full') ? 'selected="selected"' : '' ?> ><?php _e('Original Resolution', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <?php
                                            global $_wp_additional_image_sizes;
                                            $thumb_sizes = array();
                                            $image_size = get_intermediate_image_sizes();
                                            foreach ($image_size as $s) {
                                                $thumb_sizes [$s] = array(0, 0);
                                                if (in_array($s, array('thumbnail', 'medium', 'large'))) {
                                                    ?>
                                                    <option value="<?php echo $s; ?>" <?php echo (isset($bdp_settings['bdp_media_size']) && $bdp_settings['bdp_media_size'] == $s ) ? 'selected="selected"' : ''; ?>> <?php echo $s . ' (' . get_option($s . '_size_w') . 'x' . get_option($s . '_size_h') . ')'; ?> </option>
                                                    <?php
                                                } else {
                                                    if (isset($_wp_additional_image_sizes) && isset($_wp_additional_image_sizes[$s])) {
                                                        ?>
                                                        <option value="<?php echo $s; ?>" <?php echo (isset($bdp_settings['bdp_media_size']) && $bdp_settings['bdp_media_size'] == $s ) ? 'selected="selected"' : ''; ?>> <?php echo $s . ' (' . $_wp_additional_image_sizes[$s]['width'] . 'x' . $_wp_additional_image_sizes[$s]['height'] . ')'; ?> </option>
                                                        <?php
                                                    }
                                                }
                                            }
                                            ?>
                                            <option value="custom" <?php echo (isset($bdp_settings['bdp_media_size']) && $bdp_settings['bdp_media_size'] == 'custom') ? 'selected="selected"' : '' ?>><?php _e('Custom Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr class="bdp_media_custom_size_tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter custom size for post media', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Add Cutom Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <table class="bdp_media_custom_size_tbl">
                                            <tbody>
                                                <tr>
                                                    <td class="bdp_custom_media_size_title"><?php _e('Width', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                    <td><input type="number" onkeypress="return isNumberKey(event)" min="0" name="media_custom_width" class="media_custom_width" id="media_custom_width" value="<?php echo (isset($bdp_settings['media_custom_width']) && $bdp_settings['media_custom_width'] != '' ) ? $bdp_settings['media_custom_width'] : ''; ?>" /><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="bdp_custom_media_size_title"><?php _e('Height', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                    <td><input type="number" onkeypress="return isNumberKey(event)" min="0" name="media_custom_height" class="media_custom_height" id="media_custom_height" value="<?php echo (isset($bdp_settings['media_custom_height']) && $bdp_settings['media_custom_height'] != '' ) ? $bdp_settings['media_custom_height'] : ''; ?>"/><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsinglepostnavigation" class="postbox postbox-with-fw-options bdp-post-navigation-setting" <?php echo $bdpsinglepostnavigation_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post navigation', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Next/Previous Navigation ', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $display_navigation = isset($bdp_settings['display_navigation']) ? $bdp_settings['display_navigation'] : 0; ?>
                                        <fieldset class="bdp-social-options bdp-display_comment buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_navigation_0" name="display_navigation" type="radio" value="0" <?php checked(0, $display_navigation); ?> />
                                            <label for="display_navigation_0" <?php checked(0, $display_navigation); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_navigation_1" name="display_navigation" type="radio" value="1" <?php checked(1, $display_navigation); ?>/>
                                            <label for="display_navigation_1" <?php checked(1, $display_navigation); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="post-navigation-blocks">
                                    <td class="bdp_post_navigation_filter_title">
                                        <div class="bd-title-tooltip"><?php _e('Apply filter on post navigation', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Apply Filter on Post Navigation', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $bdp_post_navigation_filter = isset($bdp_settings['bdp_post_navigation_filter']) ? $bdp_settings['bdp_post_navigation_filter'] : ''; ?>
                                        <select name="bdp_post_navigation_filter" id="bdp_post_navigation_filter">
                                            <option value=""><?php _e('Default', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($bdp_post_navigation_filter, 'category'); ?> value="category"><?php _e('Category', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option <?php selected($bdp_post_navigation_filter, 'post_tag'); ?> value="post_tag"><?php _e('Tag', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr class="post-navigation-blocks">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post navigation title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Navigation Title', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['display_pn_title'])) {
                                            $display_pn_title = $bdp_settings['display_pn_title'];
                                        } else {
                                            $display_pn_title = 1;
                                        }
                                        ?>
                                        <fieldset class="buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_pn_title_0" name="display_pn_title" type="radio" value="0" <?php checked(0, $display_pn_title); ?> />
                                            <label for="display_pn_title_0" <?php checked(0, $display_pn_title); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_pn_title_1" name="display_pn_title" type="radio" value="1" <?php checked(1, $display_pn_title); ?>/>
                                            <label for="display_pn_title_1" <?php checked(1, $display_pn_title); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <div class="bdp-setting-description">
                                            <b class="note"><?php _e('Note:', BLOGDESIGNERPRO_TEXTDOMAIN); ?></b>
                                            <?php _e('Show post title when option is "Yes" otherwise it will display "Previous Post" and "Next Post".', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="post-navigation-blocks">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post navigation feature image', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Navigation Feature Image', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['display_pn_image'])) {
                                            $display_pn_image = $bdp_settings['display_pn_image'];
                                        } else {
                                            $display_pn_image = 1;
                                        }
                                        ?>
                                        <fieldset class="buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_pn_image_0" name="display_pn_image" type="radio" value="0" <?php checked(0, $display_pn_image); ?> />
                                            <label for="display_pn_image_0" <?php checked(0, $display_pn_image); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_pn_image_1" name="display_pn_image" type="radio" value="1" <?php checked(1, $display_pn_image); ?>/>
                                            <label for="display_pn_image_1" <?php checked(1, $display_pn_image); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="post-navigation-blocks">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable post navigation date', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Post Navigation Date', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['display_pn_date'])) {
                                            $display_pn_date = $bdp_settings['display_pn_date'];
                                        } else {
                                            $display_pn_date = 1;
                                        }
                                        ?>
                                        <fieldset class="buttonset buttonset-hide ui-buttonset" data-hide="1">
                                            <input id="display_pn_date_0" name="display_pn_date" type="radio" value="0" <?php checked(0, $display_pn_date); ?> />
                                            <label for="display_pn_date_0" <?php checked(0, $display_pn_date); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_pn_date_1" name="display_pn_date" type="radio" value="1" <?php checked(1, $display_pn_date); ?>/>
                                            <label for="display_pn_date_1" <?php checked(1, $display_pn_date); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsinglepostauthor" class="postbox postbox-with-fw-options bdp-post-navigation-setting" <?php echo $bdpauthor_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable author data', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Author Data', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['display_author_data'])) {
                                            $display_author_data = $bdp_settings['display_author_data'];
                                        } else {
                                            $display_author_data = 1;
                                        }
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author_data buttonset">
                                            <input id="display_author_data_0" name="display_author_data" type="radio" value="0" <?php checked(0, $display_author_data); ?> />
                                            <label for="display_author_data_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_author_data_1" name="display_author_data" type="radio" value="1"  <?php checked(1, $display_author_data); ?>/>
                                            <label for="display_author_data_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="display_author_biography_div">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable author biography', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Author Biography', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings['display_author_biography'])) {
                                            $display_author_biography = $bdp_settings['display_author_biography'];
                                        } else {
                                            $display_author_biography = 1;
                                        }
                                        ?>
                                        <fieldset class="bdp-social-options bdp-display_author buttonset">
                                            <input id="display_author_biography_0" name="display_author_biography" type="radio" value="0" <?php checked(0, $display_author_biography); ?> />
                                            <label for="display_author_biography_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="display_author_biography_1" name="display_author_biography" type="radio" value="1"  <?php checked(1, $display_author_biography); ?>/>
                                            <label for="display_author_biography_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="display_author_biography_div">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter lable for author title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Author Title', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" id="txtAuthorTitle" name="txtAuthorTitle" value="<?php echo isset($bdp_settings['txtAuthorTitle']) ? $bdp_settings['txtAuthorTitle'] : __('About', BLOGDESIGNERPRO_TEXTDOMAIN). ' [author]'; ?>" placeholder="<?php _e('About', BLOGDESIGNERPRO_TEXTDOMAIN); echo ' [author]'; ?>">
                                        <div class="bdp-setting-description">
                                            <b><?php _e('Note', BLOGDESIGNERPRO_TEXTDOMAIN); ?>: </b>
                                            <?php
                                            _e('Use', BLOGDESIGNERPRO_TEXTDOMAIN);
                                            echo ' [author] ';
                                            _e('to display author name with link dynamically.', BLOGDESIGNERPRO_TEXTDOMAIN);
                                            ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="display_author_biography_div">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select font size for author title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Author Title Font Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings["author_title_fontsize"])) {
                                            $author_title_fontsize = $bdp_settings["author_title_fontsize"];
                                        } else {
                                            $author_title_fontsize = 16;
                                        }
                                        ?>
                                        <div class="grid_col_space range_slider_fontsize" id="author_title_fontsize_slider"></div>
                                        <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="author_title_fontsize" id="author_title_fontsize" value="<?php echo $author_title_fontsize; ?>" onkeypress="return isNumberKey(event)" /></div>
                                    </td>
                                </tr>
                                <tr class="display_author_biography_div">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select author title font family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Author Title Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <div class="typo-field">
                                            <input type="hidden" name="author_title_fontface_font_type" id="author_title_fontface_font_type" value="<?php echo isset($bdp_settings['author_title_fontface_font_type']) ? $bdp_settings['author_title_fontface_font_type'] : 'Serif Fonts'; ?>">
                                            <?php
                                            $author_title_fontface = '';
                                            if (isset($bdp_settings['author_title_fontface'])) {
                                                $author_title_fontface = $bdp_settings['author_title_fontface'];
                                            }
                                            ?>
                                            <select name="author_title_fontface" id="author_title_fontface">
                                                <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <?php
                                                $old_version = '';
                                                $cnt = 0;
                                                foreach ($font_family as $key => $value) {
                                                    if ($value['version'] != $old_version) {
                                                        if ($cnt > 0) {
                                                            echo '</optgroup>';
                                                        }
                                                        echo '<optgroup label="' . $value['version'] . '">';
                                                        $old_version = $value['version'];
                                                    }
                                                    echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                    if ($author_title_fontface != '' && (str_replace('"', '', $author_title_fontface) == str_replace('"', '', $value['label']))) {
                                                        echo ' selected';
                                                    }
                                                    echo ">" . $value['label'] . "</option>";
                                                    $cnt++;
                                                }
                                                if ($cnt == count($font_family)) {
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsinglerelated" class="postbox postbox-with-fw-options bdp-content-setting1" <?php echo $bdprelated_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable related post on single page', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Display Related Post On Single Page', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <label>
                                            <input id="display_related_post" name="display_related_post" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['display_related_post'])) {
                                                checked(1, $bdp_settings['display_related_post']);
                                            }
                                            ?> />
                                        </label>
                                    </td>
                                </tr>


                                <tr class="bdp_single_custom_media_selection_related_post">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select size of related post media', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Select Post Media Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <select id="bdp_related_post_media_size" name="bdp_related_post_media_size">
                                            <option value="full" <?php echo (isset($bdp_settings['bdp_related_post_media_size']) && $bdp_settings['bdp_related_post_media_size'] == 'full') ? 'selected="selected"' : '' ?> ><?php _e('Original Resolution', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <?php
                                            global $_wp_additional_image_sizes;
                                            $thumb_sizes = array();
                                            $image_size = get_intermediate_image_sizes();
                                            foreach ($image_size as $s) {
                                                $thumb_sizes [$s] = array(0, 0);
                                                if (in_array($s, array('thumbnail', 'medium', 'large'))) {
                                                    ?>
                                                    <option value="<?php echo $s; ?>" <?php echo (isset($bdp_settings['bdp_related_post_media_size']) && $bdp_settings['bdp_related_post_media_size'] == $s ) ? 'selected="selected"' : ''; ?>> <?php echo $s . ' (' . get_option($s . '_size_w') . 'x' . get_option($s . '_size_h') . ')'; ?> </option>
                                                    <?php
                                                } else {
                                                    if (isset($_wp_additional_image_sizes) && isset($_wp_additional_image_sizes[$s])) {
                                                        ?>
                                                        <option value="<?php echo $s; ?>" <?php echo (isset($bdp_settings['bdp_related_post_media_size']) && $bdp_settings['bdp_related_post_media_size'] == $s ) ? 'selected="selected"' : ''; ?>> <?php echo $s . ' (' . $_wp_additional_image_sizes[$s]['width'] . 'x' . $_wp_additional_image_sizes[$s]['height'] . ')'; ?> </option>
                                                        <?php
                                                    }
                                                }
                                            }
                                            ?>
                                            <option value="custom" <?php echo (isset($bdp_settings['bdp_related_post_media_size']) && $bdp_settings['bdp_related_post_media_size'] == 'custom') ? 'selected="selected"' : '' ?>><?php _e('Custom Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                    </td>
                                </tr>

                                <tr class="bdp_related_post_media_custom_size_tr">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter custom size for post media', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Add Cutom Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <table class="bdp_media_custom_size_tbl">
                                            <tbody>
                                                <tr>
                                                    <td class="bdp_custom_media_size_title"><?php _e('Width', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                    <td><input type="number" onkeypress="return isNumberKey(event)" min="0" name="related_post_media_custom_width" class="media_custom_width" id="related_post_media_custom_width" value="<?php echo (isset($bdp_settings['related_post_media_custom_width']) && $bdp_settings['related_post_media_custom_width'] != '' ) ? $bdp_settings['related_post_media_custom_width'] : ''; ?>" /><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="bdp_custom_media_size_title"><?php _e('Height', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                    <td><input type="number" onkeypress="return isNumberKey(event)" min="0" name="related_post_media_custom_height" class="media_custom_height" id="related_post_media_custom_height" value="<?php echo (isset($bdp_settings['related_post_media_custom_width']) && $bdp_settings['related_post_media_custom_width'] != '' ) ? $bdp_settings['related_post_media_custom_width'] : ''; ?>"/><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>


                                <tr class="related_post_text">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter related post title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Related Post Title', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="related_post_title" id="related_post_title" value="<?php
                                        if (isset($bdp_settings['related_post_title'])) {
                                            echo $bdp_settings['related_post_title'];
                                        }
                                        ?>" placeholder="<?php _e('Enter Related Post Title', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select related post title font size', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Related Post Title Font Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings["related_title_fontsize"])) {
                                            $related_title_fontsize = $bdp_settings["related_title_fontsize"];
                                        } else {
                                            $related_title_fontsize = 25;
                                        }
                                        ?>
                                        <div class="grid_col_space range_slider_fontsize" id="related_post_fontsize" data-value="<?php echo $related_title_fontsize; ?>" ></div>
                                        <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="related_title_fontsize" id="related_title_fontsize" value="<?php echo $related_title_fontsize; ?>" onkeypress="return isNumberKey(event)" /></div><?php _e('px', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select related post title font family ', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Related Post Title Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <div class="typo-field">
                                            <input type="hidden" name="related_title_fontface_font_type" id="related_title_fontface_font_type" value="<?php echo isset($bdp_settings['related_title_fontface_font_type']) ? $bdp_settings['related_title_fontface_font_type'] : 'Serif Fonts'; ?>">
                                            <?php
                                            if (isset($bdp_settings['related_title_fontface'])) {
                                                $related_title_fontface = $bdp_settings['related_title_fontface'];
                                            } else {
                                                $related_title_fontface = 'Georgia, serif';
                                            }
                                            ?>
                                            <select name="related_title_fontface" id="related_title_fontface">
                                                <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <?php
                                                $old_version = '';
                                                $cnt = 0;
                                                foreach ($font_family as $key => $value) {
                                                    if ($value['version'] != $old_version) {
                                                        if ($cnt > 0) {
                                                            echo '</optgroup>';
                                                        }
                                                        echo '<optgroup label="' . $value['version'] . '">';
                                                        $old_version = $value['version'];
                                                    }
                                                    echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                    if ($related_title_fontface != '' && (str_replace('"', '', $related_title_fontface) == str_replace('"', '', $value['label']))) {
                                                        echo ' selected';
                                                    }
                                                    echo ">" . $value['label'] . "</option>";
                                                    $cnt++;
                                                }
                                                if ($cnt == count($font_family)) {
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select related post title color', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Related Post Title Color', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="text" name="related_title_color" id="related_title_color" value="<?php echo isset($bdp_settings["related_title_color"]) ? $bdp_settings["related_title_color"] : '#333333'; ?>"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Display related post by category or tag', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Show Related Posts By', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $related_post_by = isset($bdp_settings["related_post_by"]) ? $bdp_settings["related_post_by"] : '';
                                        ?>
                                        <select name="related_post_by" id="related_post_by">
                                            <option selected="" value="category" <?php if ($related_post_by == 'category') { ?> selected="selected"<?php } ?>>
                                                <?php _e('Category', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                            </option>
                                            <option value="tag" <?php if ($related_post_by == 'tag') { ?> selected="selected"<?php } ?>>
                                                <?php _e('Tag', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                            </option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select sorting order of related post', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Related Posts Order By', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $related_orderby = '';
                                        if (isset($bdp_settings['bdp_related_post_order_by'])) {
                                            $related_orderby = $bdp_settings['bdp_related_post_order_by'];
                                        }
                                        ?>
                                        <select id="bdp_related_post_order_by" name="bdp_related_post_order_by">
                                            <option value="" <?php echo selected('', $related_orderby); ?>><?php _e('Default Sorting', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="rand" <?php echo selected('rand', $related_orderby); ?>><?php _e('Random', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="ID" <?php echo selected('ID', $related_orderby); ?>><?php _e('Post ID', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="author" <?php echo selected('author', $related_orderby); ?>><?php _e('Author', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="title" <?php echo selected('title', $related_orderby); ?>><?php _e('Post Title', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="name" <?php echo selected('name', $related_orderby); ?>><?php _e('Post Slug', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="date" <?php echo selected('date', $related_orderby); ?>><?php _e('Publish Date', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="modified" <?php echo selected('modified', $related_orderby); ?>><?php _e('Modified Date', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="meta_value_num" <?php echo selected('meta_value_num', $related_orderby); ?>><?php _e('Post Likes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                        <?php ?>
                                        <div class="blg_order">
                                            <?php
                                            $related_post_order = 'DESC';
                                            if (isset($bdp_settings['bdp_related_post_order'])) {
                                                $related_post_order = $bdp_settings['bdp_related_post_order'];
                                            }
                                            ?>
                                            <fieldset class="buttonset green" data-hide='1'>
                                                <input id="bdp_related_post_asc" name="bdp_related_post_order" type="radio" value="ASC" <?php checked('ASC', $related_post_order); ?> />
                                                <label id="bdp-options-button" for="bdp_related_post_asc"><?php _e('Ascending', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                                <input id="bdp_related_post_desc" name="bdp_related_post_order" type="radio" value="DESC" <?php checked('DESC', $related_post_order); ?> />
                                                <label id="bdp-options-button" for="bdp_related_post_desc"><?php _e('Descending', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            </fieldset>
                                        </div>
                                        <?php ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select number of related posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Number Of Related Posts', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings["related_post_number"])) {
                                            $bdp_settings["related_post_number"] = $bdp_settings["related_post_number"];
                                        } else {
                                            $bdp_settings["related_post_number"] = 3;
                                        }
                                        ?>
                                        <select name="related_post_number" id="related_post_number">
                                            <option selected="" value="2" <?php if ($bdp_settings["related_post_number"] == '2') { ?> selected="selected"<?php } ?>>2</option>
                                            <option value="3" <?php if ($bdp_settings["related_post_number"] == '3') { ?> selected="selected"<?php } ?>>3</option>
                                            <option value="4" <?php if ($bdp_settings["related_post_number"] == '4') { ?> selected="selected"<?php } ?>>4</option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Display content from post content or excerpt', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Show Content From', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $template_post_content_from = isset($bdp_settings['related_post_content_from']) ? $bdp_settings['related_post_content_from'] : 'from_content'; ?>
                                        <select name="related_post_content_from" id="related_post_content_from">
                                            <option value="from_content" <?php selected($template_post_content_from, 'from_content'); ?> ><?php _e('Post Content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            <option value="from_excerpt" <?php selected($template_post_content_from, 'from_excerpt'); ?>><?php _e('Post Excerpt', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                        </select>
                                        <div class="bdp-setting-description">
                                            <b class="note"><?php _e("Note", BLOGDESIGNERPRO_TEXTDOMAIN); ?>:</b> &nbsp;
                                            <?php _e('If  Post Excerpt is empty then Content will get automatically from Post Content.', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter post content length', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Post Content Length', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <input type="number" id="related_post_content_length" name="related_post_content_length" step="1" min="0" value="<?php echo isset($bdp_settings['related_post_content_length']) ? $bdp_settings['related_post_content_length'] : ''; ?>" placeholder="<?php _e('Enter Content length', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" onkeypress="return isNumberKey(event)">
                                        <?php _e('Words', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        <div class="bdp-setting-description">
                                            <b class="note"><?php _e('Note', BLOGDESIGNERPRO_TEXTDOMAIN); ?>: </b>
                                            <?php _e('Leave it blank if you want to hide content in related post.', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="bdpsinglesocial" class="postbox postbox-with-fw-options" <?php echo $bdpsocial_class_show; ?>>
                    <div class="inside">
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select social share style', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Social Share Style', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $social_style = '1';
                                        if (isset($bdp_settings['social_style'])) {
                                            $social_style = $bdp_settings['social_style'];
                                        }
                                        ?>
                                        <fieldset class="bdp-social-style buttonset buttonset-hide green" data-hide='1'>
                                            <input id="social_style_0" name="social_style" type="radio" value="0" <?php checked(0, $social_style); ?>/>
                                            <label id="bdp-options-button" for="social_style_0" <?php checked(0, $social_style); ?>><?php _e('Custom', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="social_style_1" name="social_style" type="radio" value="1" <?php checked(1, $social_style); ?> />
                                            <label id="bdp-options-button" for="social_style_1" <?php checked(1, $social_style); ?>><?php _e('Default', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="shape_social_icon">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select shape of social icon', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Shape of Social Icon', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $social_icon_style = isset($bdp_settings['social_icon_style']) ? $bdp_settings['social_icon_style'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-shape buttonset buttonset-hide green" data-hide='1'>
                                            <input id="social_icon_style_0" name="social_icon_style" type="radio" value="0" nhp-opts-button-hide-below <?php checked(0, $social_icon_style); ?>/>
                                            <label id="bdp-options-button" for="social_icon_style_0" <?php checked(0, $social_icon_style); ?>><?php _e('Circle', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="social_icon_style_1" name="social_icon_style" type="radio" value="1" nhp-opts-button-hide-below <?php checked(1, $social_icon_style); ?> />
                                            <label id="bdp-options-button" for="social_icon_style_1" <?php checked(1, $social_icon_style); ?>><?php _e('Square', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="size_social_icon">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select size of social icon', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Size of Social Icon', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $social_icon_size = '';
                                        if (isset($bdp_settings['social_icon_size'])) {
                                            $social_icon_size = $bdp_settings['social_icon_size'];
                                        }
                                        ?>
                                        <fieldset class="bdp-social-size buttonset buttonset-hide green" data-hide='1'>
                                            <input id="social_icon_size_0" name="social_icon_size" type="radio" value="0" <?php checked(0, $social_icon_size); ?>/>
                                            <label id="bdp-options-button" for="social_icon_size_0" <?php checked(0, $social_icon_size); ?>><?php _e('Large', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="social_icon_size_1" name="social_icon_size" type="radio" value="1" <?php checked(1, $social_icon_size); ?> />
                                            <label id="bdp-options-button" for="social_icon_size_1" <?php checked(1, $social_icon_size); ?>><?php _e('Small', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="social_icon_size_2" name="social_icon_size" type="radio" value="2" <?php checked(2, $social_icon_size); ?> />
                                            <label id="bdp-options-button" for="social_icon_size_2" <?php checked(2, $social_icon_size); ?>><?php _e('Extra Small', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="default_icon_layouts">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select icon theme from available icon theme', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Available Icon Themes', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $default_icon_theme = 1;
                                        if (isset($bdp_settings['default_icon_theme'])) {
                                            $default_icon_theme = $bdp_settings['default_icon_theme'];
                                        }
                                        ?>
                                        <div class="social-share-theme">
                                            <?php
                                            for ($i = 1; $i <= 10; $i++) {
                                                ?>
                                                <div class="social-cover social_share_theme_<?php echo $i; ?>">
                                                    <label><input type="radio" id="default_icon_theme_<?php echo $i; ?>" value="<?php echo $i; ?>" name="default_icon_theme" <?php checked($i, $default_icon_theme); ?> />
                                                        <span class="bdp-social-icons facebook-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons gmail-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons twitter-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons linkdin-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons pin-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons whatsup-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons telegram-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons pocket-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons mail-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons reddit-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons digg-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons tumblr-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons skype-icon bdp_theme_wrapper"></span>
                                                        <span class="bdp-social-icons wordpress-icon bdp_theme_wrapper"></span>
                                                    </label>
                                                </div>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable facebook share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Facebook Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $facebook_link = isset($bdp_settings['facebook_link']) ? $bdp_settings['facebook_link'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-facebook_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="facebook_link_0" name="facebook_link" type="radio" value="0" <?php checked(0, $facebook_link); ?> />
                                            <label id="" for="facebook_link_0" <?php checked(0, $facebook_link); ?>> <?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="facebook_link_1" name="facebook_link" type="radio" value="1" <?php checked(1, $facebook_link); ?>/>
                                            <label id=""for="facebook_link_1" <?php checked(1, $facebook_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="social_link_with_count">
                                            <input id="facebook_link_with_count" name="facebook_link_with_count" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['facebook_link_with_count'])) {
                                                checked(1, $bdp_settings['facebook_link_with_count']);
                                            }
                                            ?> />
                                                   <?php _e('Hide Facebook Share Count', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable twitter share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Twitter Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $twitter_link = isset($bdp_settings['twitter_link']) ? $bdp_settings['twitter_link'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-twitter_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="twitter_link_0" name="twitter_link" type="radio" value="0" <?php checked(0, $twitter_link); ?> />
                                            <label for="twitter_link_0" <?php checked(0, $twitter_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="twitter_link_1" name="twitter_link" type="radio" value="1" <?php checked(1, $twitter_link); ?>/>
                                            <label for="twitter_link_1" <?php checked(1, $twitter_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable Google+ share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Google+ Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $google_link = isset($bdp_settings['google_link']) ? $bdp_settings['google_link'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-google_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="google_link_0" name="google_link" type="radio" value="0" <?php checked(0, $google_link); ?> />
                                            <label for="google_link_0" <?php checked(0, $google_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="google_link_1" name="google_link" type="radio" value="1" <?php checked(1, $google_link); ?>/>
                                            <label for="google_link_1" <?php checked(1, $google_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="social_link_with_count">
                                            <input id="google_link_with_count" name="google_link_with_count" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['google_link_with_count'])) {
                                                checked(1, $bdp_settings['google_link_with_count']);
                                            }
                                            ?> />
                                                   <?php _e('Hide Google+ Share Count', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable linkedin share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Linkedin Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $linkedin_link = isset($bdp_settings['linkedin_link']) ? $bdp_settings['linkedin_link'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-linkedin_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="linkedin_link_0" name="linkedin_link" type="radio" value="0" <?php checked(0, $linkedin_link); ?> />
                                            <label for="linkedin_link_0" <?php checked(0, $linkedin_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="linkedin_link_1" name="linkedin_link" type="radio" value="1" <?php checked(1, $linkedin_link); ?>/>
                                            <label for="linkedin_link_1" <?php checked(1, $linkedin_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="social_link_with_count">
                                            <input id="linkedin_link_with_count" name="linkedin_link_with_count" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['linkedin_link_with_count'])) {
                                                checked(1, $bdp_settings['linkedin_link_with_count']);
                                            }
                                            ?> />
                                                   <?php _e('Hide Linkedin Share Count', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable pinterest share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Pinterest Share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $pinterest_link = isset($bdp_settings['pinterest_link']) ? $bdp_settings['pinterest_link'] : 1;
                                        ?>
                                        <fieldset class="bdp-social-options bdp-linkedin_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="pinterest_link_0" name="pinterest_link" type="radio" value="0" <?php checked(0, $pinterest_link); ?> />
                                            <label for="pinterest_link_0" <?php checked(0, $pinterest_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="pinterest_link_1" name="pinterest_link" type="radio" value="1" <?php checked(1, $pinterest_link); ?>/>
                                            <label for="pinterest_link_1" <?php checked(1, $pinterest_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                        <label class="social_link_with_count">
                                            <input id="pinterest_link_with_count" name="pinterest_link_with_count" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['pinterest_link_with_count'])) {
                                                checked(1, $bdp_settings['pinterest_link_with_count']);
                                            }
                                            ?> />
                                                   <?php _e('Hide Pinterest Share Count', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable pinterest share button on feature image', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Show Pinterest Share Button on Feature Image', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <label>
                                            <input id="pinterest_image_share" name="pinterest_image_share" type="checkbox" value="1" <?php
                                            if (isset($bdp_settings['pinterest_image_share'])) {
                                                checked(1, $bdp_settings['pinterest_image_share']);
                                            }
                                            ?> />
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable skype share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Skype Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $skype_link = isset($bdp_settings['skype_link']) ? $bdp_settings['skype_link'] : '0'; ?>
                                        <fieldset class="bdp-social-options bdp-twitter_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="skype_link_0" name="skype_link" type="radio" value="0" <?php checked(0, $skype_link); ?> />
                                            <label for="skype_link_0" <?php checked(0, $skype_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="skype_link_1" name="skype_link" type="radio" value="1" <?php checked(1, $skype_link); ?>/>
                                            <label for="skype_link_1" <?php checked(1, $skype_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable pocket share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Pocket Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <?php $pocket_link = isset($bdp_settings['pocket_link']) ? $bdp_settings['pocket_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-pocket_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="pocket_link_0" name="pocket_link" type="radio" value="0" <?php checked(0, $pocket_link); ?> />
                                            <label for="pocket_link_0" <?php checked(0, $pocket_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="pocket_link_1" name="pocket_link" type="radio" value="1" <?php checked(1, $pocket_link); ?>/>
                                            <label for="pocket_link_1" <?php checked(1, $pocket_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable telegram share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Telegram Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <?php $telegram_link = isset($bdp_settings['telegram_link']) ? $bdp_settings['telegram_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-telegram_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="telegram_link_0" name="telegram_link" type="radio" value="0" <?php checked(0, $telegram_link); ?> />
                                            <label for="telegram_link_0" <?php checked(0, $telegram_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="telegram_link_1" name="telegram_link" type="radio" value="1" <?php checked(1, $telegram_link); ?>/>
                                            <label for="telegram_link_1" <?php checked(1, $telegram_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable reddit share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Reddit Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <?php $reddit_link = isset($bdp_settings['reddit_link']) ? $bdp_settings['reddit_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-reddit_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="reddit_link_0" name="reddit_link" type="radio" value="0" <?php checked(0, $reddit_link); ?> />
                                            <label for="reddit_link_0" <?php checked(0, $reddit_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="reddit_link_1" name="reddit_link" type="radio" value="1" <?php checked(1, $reddit_link); ?>/>
                                            <label for="reddit_link_1" <?php checked(1, $reddit_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable digg share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Digg Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                        <?php $digg_link = isset($bdp_settings['digg_link']) ? $bdp_settings['digg_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-reddit_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="digg_link_0" name="digg_link" type="radio" value="0" <?php checked(0, $digg_link); ?> />
                                            <label for="digg_link_0" <?php checked(0, $digg_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="digg_link_1" name="digg_link" type="radio" value="1" <?php checked(1, $digg_link); ?>/>
                                            <label for="digg_link_1" <?php checked(1, $digg_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable tumblr share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('Tumblr Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                        <?php $tumblr_link = isset($bdp_settings['tumblr_link']) ? $bdp_settings['tumblr_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-tumblr_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="tumblr_link_0" name="tumblr_link" type="radio" value="0" <?php checked(0, $tumblr_link); ?> />
                                            <label for="tumblr_link_0" <?php checked(0, $tumblr_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="tumblr_link_1" name="tumblr_link" type="radio" value="1" <?php checked(1, $tumblr_link); ?>/>
                                            <label for="tumblr_link_1" <?php checked(1, $tumblr_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable wordpress share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                    <?php _e('WordPress Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                        <?php $wordpress_link = isset($bdp_settings['wordpress_link']) ? $bdp_settings['wordpress_link'] : '0'; ?>
                                    <td>
                                        <fieldset class="bdp-social-options bdp-wordpress_link buttonset buttonset-hide" data-hide='1'>
                                            <input id="wordpress_link_0" name="wordpress_link" type="radio" value="0" <?php checked(0, $wordpress_link); ?> />
                                            <label for="wordpress_link_0" <?php checked(0, $wordpress_link); ?>><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="wordpress_link_1" name="wordpress_link" type="radio" value="1" <?php checked(1, $wordpress_link); ?>/>
                                            <label for="wordpress_link_1" <?php checked(1, $wordpress_link); ?>><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable mail share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Share via Mail', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $email_link = isset($bdp_settings['email_link']) ? $bdp_settings['email_link'] : 0; ?>
                                        <fieldset class="bdp-social-options bdp-linkedin_link buttonset">
                                            <label id="bdp-opts-button" for="email_link_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="email_link_0" class="bdp-opts-button" name="email_link" type="radio" value="0" <?php checked(0, $email_link); ?> />
                                            <input id="email_link_1" class="bdp-opts-button" name="email_link" type="radio" value="1" <?php checked(1, $email_link); ?>/>
                                            <label id="bdp-opts-button" for="email_link_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr class="mail_share_content">
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Mail share Content', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Mail Share Content', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $mail_subject = (isset($bdp_settings['mail_subject']) && $bdp_settings['mail_subject'] != '') ? $bdp_settings['mail_subject'] : '[post_title]' ?>
                                        <input type="text" name="mail_subject" id="mail_subject" value="<?php echo $mail_subject; ?>" placeholder="<?php esc_attr_e('Enter Mail Subject', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">


                                        <?php
                                        $settings = array(
                                            'wpautop' => true,
                                            'media_buttons' => true,
                                            'textarea_name' => 'mail_content',
                                            'textarea_rows' => 10,
                                            'tabindex' => '',
                                            'editor_css' => '',
                                            'editor_class' => '',
                                            'teeny' => false,
                                            'dfw' => false,
                                            'tinymce' => true,
                                            'quicktags' => true
                                        );
                                        if(isset($bdp_settings['mail_content']) && $bdp_settings['mail_content'] != '') {
                                            $contents = $bdp_settings['mail_content'];
                                        } else {
                                            $contents =  __("My Dear friends", BLOGDESIGNERPRO_TEXTDOMAIN). '<br/><br/>' . __('I read one good blog link and I would like to share that same link for you. That might useful for you', BLOGDESIGNERPRO_TEXTDOMAIN) .'<br/><br/>[post_link]<br/><br/>'. __("Best Regards", BLOGDESIGNERPRO_TEXTDOMAIN). ',<br/>' .__("Blog Designer", BLOGDESIGNERPRO_TEXTDOMAIN);
                                        }

                                        wp_editor(html_entity_decode($contents), 'mail_content', $settings); ?>
                                        <div class="div-pre">
                                            <p> [post_title] => <?php _e('Post Title', BLOGDESIGNERPRO_TEXTDOMAIN)?> </p>
                                            <p> [post_link] => <?php _e('Post Link', BLOGDESIGNERPRO_TEXTDOMAIN)?> </p>
                                            <p> [post_thumbnail] => <?php _e('Post Featured Image', BLOGDESIGNERPRO_TEXTDOMAIN)?> </p>
                                            <p> [sender_name] => <?php _e('Mail Sender Name', BLOGDESIGNERPRO_TEXTDOMAIN)?> </p>
                                            <p> [sender_email] => <?php _e('Mail Sender Email Address', BLOGDESIGNERPRO_TEXTDOMAIN)?> </p>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enable/Disable whatsapp share link', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('WhatsApp Share Link', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php $whatsapp_link = isset($bdp_settings['whatsapp_link']) ? $bdp_settings['whatsapp_link'] : '0'; ?>
                                        <fieldset class="bdp-social-options bdp-whatsapp_link buttonset">
                                            <label id="bdp-opts-button" for="whatsapp_link_0"><?php _e('No', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                            <input id="whatsapp_link_0" class="bdp-opts-button" name="whatsapp_link" type="radio" value="0" <?php checked(0, $whatsapp_link); ?> />
                                            <input id="whatsapp_link_1" class="bdp-opts-button" name="whatsapp_link" type="radio" value="1" <?php checked(1, $whatsapp_link); ?>/>
                                            <label id="bdp-opts-button" for="whatsapp_link_1"><?php _e('Yes', BLOGDESIGNERPRO_TEXTDOMAIN); ?></label>
                                        </fieldset>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select social share count position', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Social Share Count Position', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        $social_count_position = 'bottom';
                                        if (isset($bdp_settings['social_count_position'])) {
                                            $social_count_position = $bdp_settings['social_count_position'];
                                        }
                                        ?>
                                        <div class="typo-field">
                                            <select name="social_count_position" id="social_sharecount">
                                                <option value="bottom" <?php echo selected('bottom', $social_count_position); ?>><?php _e('Bottom', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <option value="right" <?php echo selected('right', $social_count_position); ?>><?php _e('Right', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <option value="top" <?php echo selected('top', $social_count_position); ?>><?php _e('Top', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Enter social share text', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Social Share Text', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td class="social-share-section">
                                        <?php
                                        $txtSocialIcon = isset($bdp_settings['txtSocialIcon']) ? sanitize_text_field($bdp_settings['txtSocialIcon']) : 'fa fa-share';
                                        $txtSocialText = isset($bdp_settings['txtSocialText']) ? sanitize_text_field($bdp_settings['txtSocialText']) : __('Share this post', BLOGDESIGNERPRO_TEXTDOMAIN);
                                        ?>
                                        <input class="icon" type="text" id="txtSocialIcon" name="txtSocialIcon" value="<?php echo $txtSocialIcon; ?>" placeholder="<?php echo 'fa fa-share'; ?>">
                                        <input class="text" type="text" id="txtSocialText" name="txtSocialText" value="<?php echo $txtSocialText; ?>" placeholder="<?php _e('Share this post', BLOGDESIGNERPRO_TEXTDOMAIN); ?>">
                                        <div id="dialogbox" class="dialogbox single_layout" title="<?php _e('Select Icon', BLOGDESIGNERPRO_TEXTDOMAIN); ?>" style="display:none">
                                            <div class="icon_div"> </div>
                                    </td>
                                    </div>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select social share text font family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Social Share Text Font', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <div class="typo-field">
                                            <input type="hidden" name="txtSocialTextFont_font_type" id="txtSocialTextFont_font_type" value="<?php echo isset($bdp_settings['txtSocialTextFont_font_type']) ? $bdp_settings['txtSocialTextFont_font_type'] : 'Serif Fonts'; ?>">
                                            <select name="txtSocialTextFont" id="txtSocialTextFont">
                                                <option value=""><?php _e('Select Font Family', BLOGDESIGNERPRO_TEXTDOMAIN); ?></option>
                                                <?php
                                                $txtSocialTextFont = '';
                                                if (isset($bdp_settings['txtSocialTextFont'])) {
                                                    $txtSocialTextFont = $bdp_settings['txtSocialTextFont'];
                                                }
                                                $old_version = '';
                                                $cnt = 0;
                                                foreach ($font_family as $key => $value) {
                                                    if ($value['version'] != $old_version) {
                                                        if ($cnt > 0) {
                                                            echo '</optgroup>';
                                                        }
                                                        echo '<optgroup label="' . $value['version'] . '">';
                                                        $old_version = $value['version'];
                                                    }
                                                    echo "<option value='" . str_replace('"', '', $value['label']) . "'";

                                                    if ($txtSocialTextFont != '' && (str_replace('"', '', $txtSocialTextFont) == str_replace('"', '', $value['label']))) {
                                                        echo ' selected';
                                                    }
                                                    echo ">" . $value['label'] . "</option>";
                                                    $cnt++;
                                                }
                                                if ($cnt == count($font_family)) {
                                                    echo '</optgroup>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="bd-title-tooltip"><?php _e('Select social share text font size', BLOGDESIGNERPRO_TEXTDOMAIN); ?></div>
                                        <?php _e('Social Share Text Size', BLOGDESIGNERPRO_TEXTDOMAIN); ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($bdp_settings["txtSocialTextSize"])) {
                                            $txtSocialTextSize = $bdp_settings["txtSocialTextSize"];
                                        } else {
                                            $txtSocialTextSize = 25;
                                        }
                                        ?>
                                        <div class="grid_col_space range_slider_fontsize" id="social_share_fontsize" data-value="<?php echo $txtSocialTextSize; ?>"></div>
                                        <div class="slide_val"><span></span><input class="grid_col_space_val range-slider__value" name="txtSocialTextSize" id="txtSocialTextSize" value="<?php echo $txtSocialTextSize; ?>" onkeypress="return isNumberKey(event)" /></div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div id="popupdiv-single" class="bdp-template-popupdiv" style="display: none;">
        <ul class="bdp_template_tab">
            <li class="current_tab">
                <a href="#all"><?php _e('All', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li class="">
                <a href="#full-width"><?php _e('Full Width', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li>
                <a href="#grid"><?php _e('Grid', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li>
                <a href="#masonry"><?php _e('Masonry', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li>
                <a href="#odd-even"><?php _e('2 Columns', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li>
                <a href="#box-view"><?php _e('Box View', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <li>
                <a href="#timeline"><?php _e('Timeline', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a>
            </li>
            <div class="bdp-single-blog-template-search-cover">
                <input type="text" class="bdp-template-search" id="bdp-template-search" placeholder="<?php _e('Search Template', BLOGDESIGNERPRO_TEXTDOMAIN);?>" />
                <span class="bdp-template-search-clear"></span>
            </div>
        </ul>
        <?php
        $tempate_list = bdp_single_blog_template_list();
        echo '<div class="bdp-blog-template-cover">';
        foreach ($tempate_list as $key => $value) {
            ?>
            <div class="template-thumbnail <?php echo $value['class']; ?>">
                <div class="template-thumbnail-inner">
                    <img src="<?php echo BLOGDESIGNERPRO_URL . '/admin/images/single/' . $value['image_name']; ?>" data-value="<?php echo $key; ?>" alt="<?php echo $value['template_name']; ?>" title="<?php echo $value['template_name']; ?>">
                    <div class="hover_overlay">
                        <div class="popup-template-name">
                            <div class="popup-select"><a href="#"><?php _e('Select Template', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a></div>
                            <div class="popup-view"><a href="<?php echo $value['demo_link']; ?>" target="_blank"><?php _e('Live Demo', BLOGDESIGNERPRO_TEXTDOMAIN); ?></a></div>
                        </div>
                    </div>
                </div>
                <span class="bdp-span-template-name"><?php echo $value['template_name']; ?></span>
            </div>
            <?php
        }
        echo '</div>';
        echo '<h3 class="no-template" style="display: none;">'. __('No template found. Please try again', BLOGDESIGNERPRO_TEXTDOMAIN) .'</h3>';
        ?>
    </div>
</div>