<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $post;
$class_name = "blog_template bdp_blog_template evolution";
if ($alter_class != '') {
    $class_name .= " " . $alter_class;
}
$image_hover_effect = '';
if(isset($bdp_settings['bdp_image_hover_effect']) && $bdp_settings['bdp_image_hover_effect'] == 1) {
    $image_hover_effect = (isset($bdp_settings['bdp_image_hover_effect_type']) && $bdp_settings['bdp_image_hover_effect_type'] != '') ? $bdp_settings['bdp_image_hover_effect_type'] : '';
}
?>
<div class="<?php echo $class_name; ?>">
    <?php do_action('bdp_before_post_content'); ?>
    <?php if ($bdp_settings['display_category'] == 1 && $bdp_settings['custom_post_type'] == 'post') { ?>
        <div class="post-category"><?php
            $categories_list = get_the_category_list(', ');
            $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
            if ($categories_link) {
                $categories_list = strip_tags($categories_list);
            }
            if ($categories_list):
                print_r($categories_list);
                $show_sep = true;
            endif;
            ?>
        </div><?php
    }
    if ($bdp_settings['custom_post_type'] != 'post') {
        $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type'],'objects');
        foreach ($taxonomy_names as $taxonomy_single) {
            $taxonomy = $taxonomy_single->name;
            if ($bdp_settings["display_taxonomy_" . $taxonomy] == 1) {
                ?>
                <div class="post-category"><?php
                    $term_list = wp_get_post_terms(get_the_ID(), $taxonomy, array("fields" => "all"));
                    $taxonomy_link = (isset($bdp_settings['disable_link_taxonomy_' . $taxonomy]) && $bdp_settings['disable_link_taxonomy_' . $taxonomy] == 1) ? false : true;
                    if (isset($taxonomy)) {
                        if (isset($term_list) && !empty($term_list)) {
                            ?>
                            <span class="taxonomies <?php echo $taxonomy; ?>">
                                <strong><?php echo $taxonomy_single->label; ?>&nbsp;:&nbsp;</strong>
                                <span class="terms"><?php
                                    foreach ($term_list as $term_nm) {
                                        $term_link = get_term_link($term_nm);

                                        echo ($taxonomy_link) ? '<a href="' . $term_link . '">' : '';
                                        echo $term_nm->name;
                                        ?><span class="seperater"><?php echo ', '; ?></span><?php
                                        echo ($taxonomy_link) ? '</a>' : '';
                                        ?>

                                    <?php }
                                    ?>
                                </span>
                            </span><?php
                        }
                    }
                    ?>
                </div><?php
            }
        }
    }
    ?>
    <h2 class="post-title">
        <?php
        $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
        if ($bdp_post_title_link == 1) {
            ?>
            <a href="<?php the_permalink(); ?>">
            <?php } ?>
            <?php
            echo get_the_title();
            if ($bdp_post_title_link == 1) {
                ?>
            </a>
        <?php } ?>
    </h2>
    <div class="post-entry-meta">
        <?php
        if ($bdp_settings['display_date'] == 1) {
            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
            $date_format = get_option('date_format');
            $ar_year = get_the_time('Y');
            $ar_month = get_the_time('m');
            $ar_day = get_the_time('d');
            ?>
            <span class="date">
                <i class="fa fa-clock-o"></i>
                <span class="number-date">
                    <?php
                    echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                    echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                    echo ($date_link) ? '</a>' : '';
                    ?>
                </span>
            </span>
            <?php
        }
        if ($bdp_settings['display_author'] == 1) {
            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
            ?>
            <span class="author">
                <span class="link-lable"> <i class="fa fa-user"></i> <?php   _e('Posted by ', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                <?php
                echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                echo get_the_author();
                echo ($author_link) ? '</a>' : '';
                ?>
            </span>
            <?php
        }
        if ($bdp_settings['display_comment_count'] == 1) {
            if (!post_password_required() && ( comments_open() || get_comments_number() )) :
                ?>
                <span class="comment">
                    <span class="icon_cnt">
                        <i class="fa fa-comment"></i>
                        <?php
                        $comment_link = (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) ? false : true;
                        bdp_comment_count($comment_link); //comments_popup_link('0', '1', '%');
                        ?>
                    </span>
                </span>
                <?php
            endif;
        }
        if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
            echo do_shortcode('[likebtn_shortcode]');
        }
        ?>
    </div>
    <div class="post-image-content-wrap">
        <?php
        if (bdp_get_first_embed_media($post->ID) && $bdp_settings['rss_use_excerpt'] == 1) {
            if (get_post_format() == 'quote') {
                if (has_post_thumbnail()) {                    
                    $post_thumbnail = 'full';
                    $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                    echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                    echo '<figure class="'. $image_hover_effect .'">';
                    echo '<div class="upper_image_wrapper">';
                    echo bdp_get_first_embed_media($post->ID);
                    echo '</div>';
                    echo '</figure>';
                }
            } else if (get_post_format() == 'link') {
                if (has_post_thumbnail()) {
                    $post_thumbnail = 'full';
                    $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
                    echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                    echo '<figure class="'. $image_hover_effect .'">';
                    echo '<div class="upper_image_wrapper bdp_link_post_format">';
                    echo bdp_get_first_embed_media($post->ID);
                    echo '</div>';
                    echo '</figure>';
                }
            } else {
                echo bdp_get_first_embed_media($post->ID);
            }
        } else {
            $post_thumbnail = 'full';
            $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);
            if (!empty($thumbnail)) {
                $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;
                echo '<figure class="'. $image_hover_effect .'">';
                ?>
                <div class="bdp-post-image">
                    <?php
                    echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
                    echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
                    echo ($bdp_post_image_link) ? '</a>' : '';

                    if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                        ?>
                        <div class="bdp-pinterest-share-image">
                            <?php
                            $img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID));
                            ?>
                            <a target="_blank" href="<?php echo 'https://pinterest.com/pin/create/button/?url=' . get_permalink($post->ID) . '&media=' . $img_url; ?>"></a>
                        </div>
                    <?php } ?>
                </div>
                <?php
                echo '</figure>';
            }
        }
        ?>
    </div>
    <div class="post-content-body post_content <?php
    if ($bdp_settings['rss_use_excerpt'] == 0) {
        echo 'blog_full_content';
    }
    ?>">
             <?php
             echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
             ?>
    </div>
    <div class="footer_meta">
        <?php
        if ($bdp_settings['display_tag'] == 1 && $bdp_settings['custom_post_type'] == 'post') {
            $tags_list = get_the_tag_list('', ', ');
            $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
            if ($tag_link) {
                $tags_list = strip_tags($tags_list);
            }
            if ($tags_list):
                ?>
                <span class="tags">
                    <i class="fa fa-tags"></i>
                    <?php
                    print_r($tags_list);
                    $show_sep = true;
                    ?>
                </span>
                <?php
            endif;
        }
        ?>
        <span class="border_top"></span>
        <?php if ($bdp_settings['rss_use_excerpt'] == 1): ?>
            <div class="post-bottom">
                <?php
                if ($bdp_settings['txtReadmoretext'] != '') {
                    echo '<a href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a>';
                } else {
                    echo ' <a href="' . get_permalink($post->ID) . '">' . __('Read more', BLOGDESIGNERPRO_TEXTDOMAIN) . ' &raquo;</a>';
                }
                ?>
            </div>
            <?php
        endif;
        bdp_get_social_icons($bdp_settings);
        do_action('bdp_after_post_content');
        ?>
    </div>
</div>
<?php
do_action('bdp_separator_after_post');
