<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $post;

$format = get_post_format($post->ID);
$post_format = '';
if ($format == "status") {
    $post_format = 'fa fa-comment';
} elseif ($format == "aside") {
    $post_format = 'fa fa-file-text';
} elseif ($format == "image") {
    $post_format = 'fa fa-file-image-o';
} elseif ($format == "gallery") {
    $post_format = 'fa fa-file-image-o';
} elseif ($format == "link") {
    $post_format = 'fa fa-link';
} elseif ($format == "quote") {
    $post_format = 'fa fa-quote-left';
} elseif ($format == "audio") {
    $post_format = 'fa fa-music';
} elseif ($format == "video") {
    $post_format = 'fa fa-video-camera';
} elseif ($format == "chat") {
    $post_format = 'fa fa-wechat';
} else {
    $post_format = 'fa fa-thumb-tack';
}
$image_hover_effect = '';
if(isset($bdp_settings['bdp_image_hover_effect']) && $bdp_settings['bdp_image_hover_effect'] == 1) {
    $image_hover_effect = (isset($bdp_settings['bdp_image_hover_effect_type']) && $bdp_settings['bdp_image_hover_effect_type'] != '') ? $bdp_settings['bdp_image_hover_effect_type'] : '';
}
?>
<div class="bdp_blog_template diary-post">
    <?php do_action('bdp_before_post_content'); ?>
    <div class="diary-thumb">
        <?php
        $bdp_post_image_link = (isset($bdp_settings['bdp_post_image_link']) && $bdp_settings['bdp_post_image_link'] == 0) ? false : true;

        $post_thumbnail = 'deport-thumb';
        $thumbnail = bdp_get_the_thumbnail($bdp_settings, $post_thumbnail, get_post_thumbnail_id(), $post->ID);

        if (!empty($thumbnail)) {
            echo '<figure class="'. $image_hover_effect .'">';
            echo ($bdp_post_image_link) ? '<a href="' . get_permalink($post->ID) . '">' : '';
            echo apply_filters('bdp_post_thumbnail_filter', $thumbnail, $post->ID);
            echo ($bdp_post_image_link) ? '</a>' : '';
            echo '</figure>';
        }
        
        ?>
    </div>
    <div class="post-content-area">
        <div class="diary-posthead">
            <?php
            if ($bdp_settings['custom_post_type'] == 'post') {
                if ($bdp_settings['display_category'] == 1) {
                    ?>
                    <div class="categories">
                        <?php
                        $categories_list = get_the_category_list(', ');
                        $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                        if ($categories_link) {
                            $categories_list = strip_tags($categories_list);
                        }
                        if ($categories_list) {
                            echo '<span>' . __('in', BLOGDESIGNERPRO_TEXTDOMAIN) . '</span>';
                            print_r($categories_list);
                        }
                        ?>
                    </div>
                    <?php
                }
            } else {
                $taxonomy_names = get_object_taxonomies($bdp_settings['custom_post_type']);
                foreach ($taxonomy_names as $taxonomy) {
                    $sep = 1;
                    if (isset($bdp_settings["display_taxonomy_" . $taxonomy]) && $bdp_settings["display_taxonomy_" . $taxonomy] == 1) {
                        $term_list = wp_get_post_terms(get_the_ID(), $taxonomy, array("fields" => "all"));
                        $taxonomy_link = (isset($bdp_settings['disable_link_taxonomy_' . $taxonomy]) && $bdp_settings['disable_link_taxonomy_' . $taxonomy] == 1) ? false : true;
                        if (isset($taxonomy)) {
                            if (isset($term_list) && !empty($term_list)) {
                                ?>
                                <div class="category">
                                    <?php
                                    echo '<span>' . __('in', BLOGDESIGNERPRO_TEXTDOMAIN) . ' </span>';
                                    foreach ($term_list as $term_nm) {
                                        $term_link = get_term_link($term_nm);
                                        if ($sep != 1) {
                                            ?> <span class="seperater"><?php echo ', '; ?></span> <?php
                                        }
                                        echo ($taxonomy_link) ? '<a href="' . $term_link . '">' : '';
                                        echo $term_nm->name;
                                        echo ($taxonomy_link) ? '</a>' : '';
                                        $sep++;
                                    }
                                    ?>
                                </div>
                                <?php
                            }
                        }
                    }
                }
            }
            ?>
            <div class="post-title">
                <?php
                $bdp_post_title_link = isset($bdp_settings['bdp_post_title_link']) ? $bdp_settings['bdp_post_title_link'] : 1;
                if ($bdp_post_title_link == 1) {
                    echo '<a href="' . get_the_permalink() . '" title="' . get_the_title() . '">';
                }
                echo get_the_title();
                if ($bdp_post_title_link == 1) {
                    echo '</a>';
                }
                ?>
            </div>
            <div class="metadatabox">
                <?php
                if ($bdp_settings['display_author'] == 1) {
                    $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                    ?>
                    <div class="mauthor">
                        <span><?php _e('by', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        <?php
                        echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                        echo get_the_author();
                        echo ($author_link) ? '</a>' : '';
                        ?>
                    </div>
                    <?php
                }
                if ($bdp_settings['display_date'] == 1) {
                    $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                    $date_format = get_option('date_format');
                    $ar_year = get_the_time('Y');
                    $ar_month = get_the_time('m');
                    $ar_day = get_the_time('d');
                    ?>
                    <div class="mdate">
                        <span><?php _e('on', BLOGDESIGNERPRO_TEXTDOMAIN); ?></span>
                        <?php
                        echo ($date_link) ? '<a class="mdate" href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : '';
                        echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID);
                        echo ($date_link) ? '</a>' : '';
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <div class="diary-postcontent <?php echo $post_format; ?>">
            <?php
            if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                echo do_shortcode('[likebtn_shortcode]');
            }
            ?>
            <div class="post_content">
                <?php
                echo bdp_get_content($post->ID, $bdp_settings['rss_use_excerpt'], $bdp_settings['txtExcerptlength'], $bdp_settings);
                ?>
            </div>
            <div class="diary_postfooter">
                <?php
                if ($bdp_settings['txtReadmoretext'] != '' && $bdp_settings['rss_use_excerpt'] == 1) {
                    echo '<div class="read-more-div"><a class="more-tag" href="' . get_permalink($post->ID) . '">' . $bdp_settings['txtReadmoretext'] . ' </a></div>';
                }

                if ($bdp_settings['custom_post_type'] == 'post') {
                    if ($bdp_settings['display_tag'] == 1) {
                        $tags_list = get_the_tag_list('', ', ');
                        $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                        if ($tag_link) {
                            $tags_list = strip_tags($tags_list);
                        }
                        if ($tags_list) {
                            ?>
                            <div class="tags">
                                <i class="fa fa-bookmark"></i>
                                <?php print_r($tags_list); ?>
                            </div>
                            <?php
                        }
                    }
                }
                bdp_get_social_icons($bdp_settings);

                if ($bdp_settings['display_comment_count'] == 1) {
                    ?>
                    <div class="post-comment">
                        <i class="fa fa-comment"></i>
                        <?php
                        if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                            comments_number(__('No Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                        } else {
                            comments_popup_link(__('Leave a Comment', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('comments', BLOGDESIGNERPRO_TEXTDOMAIN), 'comments-link', __('Comments are off', BLOGDESIGNERPRO_TEXTDOMAIN));
                        }
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </div>
    <?php do_action('bdp_after_post_content'); ?>
</div>

<?php
do_action('bdp_separator_after_post');
