<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('bd_single_design_format_function', 'bdp_single_lightbreeze_template', 10, 1);
if (!function_exists('bdp_single_lightbreeze_template')) {

    /**
     * add html for lightbreeze template
     * @global object $post
     * @return html display lightbreeze design
     */
    function bdp_single_lightbreeze_template($bdp_settings) {
        global $post;
        ?>
        <div class="blog_template bdp_blog_template box-template lightbreeze">
            <?php do_action('bdp_before_single_post_content'); ?>
            <?php if (has_post_thumbnail() && isset($bdp_settings['display_thumbnail']) && $bdp_settings['display_thumbnail'] == 1) { ?>
                <div class="bdp-post-image">
                    <?php
                    $single_post_image = bdp_get_the_single_post_thumbnail($bdp_settings, get_post_thumbnail_id(), get_the_ID());
                    echo apply_filters('bdp_single_post_thumbnail_filter', $single_post_image, get_the_ID());
                    if (isset($bdp_settings['pinterest_image_share']) && $bdp_settings['pinterest_image_share'] == 1) {
                        echo bdp_pinterest($post->ID);
                    }
                    ?>
                </div>
            <?php } ?>
            <div class="blog_header <?php
            if (has_post_thumbnail()) {
                echo "blog_header_img";
            }
            ?>">
                     <?php
                     $display_title = (isset($bdp_settings['display_title']) && $bdp_settings['display_title'] != '') ? $bdp_settings['display_title'] : 1;
                     if ($display_title == 1) {
                         ?>
                        <h1 class="post-title">
                            <?php echo get_the_title(); ?>
                        </h1>
                    <?php
                }
                ?>

                <?php
                if ($bdp_settings['display_date'] == 1 || $bdp_settings['display_author'] == 1 ||
                        $bdp_settings['display_tag'] == 1 || $bdp_settings['display_comment'] == 1 || $bdp_settings['display_comment'] == 1) {
                    ?>
                    <div class="meta_data_box metadatabox">
                        <?php
                        if (isset($bdp_settings['display_author']) && $bdp_settings['display_author'] == 1) {
                            $author_link = (isset($bdp_settings['disable_link_author']) && $bdp_settings['disable_link_author'] == 1) ? false : true;
                            ?>
                            <div class="metauser">
                                <i class="fa fa-user"></i>
                                <?php
                                _e('Posted by', BLOGDESIGNERPRO_TEXTDOMAIN);
                                echo ($author_link) ? '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '">' : '';
                                ?>
                                <span>
                                    <?php echo get_the_author(); ?>
                                </span>
                                <?php
                                echo ($author_link) ? '</a>' : '';
                                ?>
                                <br />
                            </div>
                            <?php
                        }
                        if (isset($bdp_settings['display_date']) && $bdp_settings['display_date'] == 1) {
                            $ar_year = get_the_time('Y');
                            $ar_month = get_the_time('m');
                            $ar_day = get_the_time('d');
                            $date_link = (isset($bdp_settings['disable_link_date']) && $bdp_settings['disable_link_date'] == 1) ? false : true;
                            ?>
                            <div class="metadate">
                                <?php $date_format = get_option('date_format'); ?>
                                <span class="mdate"><i class="fa fa-calendar"></i>
                                    <?php echo ($date_link) ? '<a href="' . get_day_link($ar_year, $ar_month, $ar_day) . '">' : ''; ?>
                                    <?php echo apply_filters('bdp_date_format', get_the_time($date_format, $post->ID), $post->ID); ?>
                                    <?php echo ($date_link) ? '</a>' : ''; ?>
                                </span>
                            </div>
                            <?php
                        }
                        if ($bdp_settings['display_category'] == 1) {
                            ?>
                            <div class="category-link">
                                <span class="link-lable"> <i class="fa fa-folder-open"></i></span>
                                <?php
                                $categories_list = get_the_category_list(', ');
                                $categories_link = (isset($bdp_settings['disable_link_category']) && $bdp_settings['disable_link_category'] == 1) ? true : false;
                                if ($categories_link) {
                                    $categories_list = strip_tags($categories_list);
                                }
                                if ($categories_list):
                                    echo ' '; print_r($categories_list);
                                    $show_sep = true;
                                endif;
                                ?>
                            </div>
                            <?php
                        }
                        if (isset($bdp_settings['display_comment']) && $bdp_settings['display_comment'] == 1) {
                            ?>
                            <div class="metacomments">
                                <!--<div class="icon-comment"></div>-->
                                <i class="fa fa-comment"></i>
                                <?php
                                if (isset($bdp_settings['disable_link_comment']) && $bdp_settings['disable_link_comment'] == 1) {
                                    comments_number(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), '1 '.__('comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                                } else {
                                    comments_popup_link(__('No Comments', BLOGDESIGNERPRO_TEXTDOMAIN), __('1 Comment', BLOGDESIGNERPRO_TEXTDOMAIN), '% '.__('Comments', BLOGDESIGNERPRO_TEXTDOMAIN));
                                }
                                ?>
                            </div>
                            <?php
                        }
                        if (isset($bdp_settings['display_postlike']) && $bdp_settings['display_postlike'] == 1) {
                            echo do_shortcode('[likebtn_shortcode]');
                        }
                        ?>
                    </div>
                <?php } ?>
            </div>
            <div class="post_content entry-content">
                <?php
                if (isset($bdp_settings['firstletter_big']) && $bdp_settings['firstletter_big'] == 1) {
                    $content = bdp_add_first_letter_structure(get_the_content());
                    $content = apply_filters('the_content', $content);
                    $content = str_replace(']]>', ']]&gt;', $content);
                    echo $content;
                } else {
                    the_content();
                }
                if (isset($bdp_settings['display_post_views']) && $bdp_settings['display_post_views'] != 0) {
                    if (bdp_get_post_views(get_the_ID(), $bdp_settings) != '') {
                        echo '<div class="display_post_views">';
                        echo bdp_get_post_views(get_the_ID(), $bdp_settings);
                        echo '</div>';
                    }
                }
                ?>
            </div>

            <?php

            if (isset($bdp_settings['display_tag']) && $bdp_settings['display_tag'] == 1) {
                $tags_list = get_the_tag_list('', ', ');
                $tag_link = (isset($bdp_settings['disable_link_tag']) && $bdp_settings['disable_link_tag'] == 1) ? true : false;
                if ($tag_link) {
                    $tags_list = strip_tags($tags_list);
                }
                if ($tags_list):
                    ?>
                    <div class="tags">
                        <i class="fa fa-tags"></i>
                        <?php
                        print_r($tags_list);
                        $show_sep = true;
                        ?>
                    </div>
                    <?php
                endif;
            }
            if (is_single()) {
                do_action('bdp_social_share_text', $bdp_settings);
            }
            bdp_get_social_icons($bdp_settings);
            ?>
            <?php do_action('bdp_after_single_post_content'); ?>
        </div>
        <?php
        add_action('bdp_author_detail', 'bdp_display_author_image', 5, 2);
        add_action('bdp_author_detail', 'bdp_display_author_content_cover_start', 10, 2);
        add_action('bdp_author_detail', 'bdp_display_author_name', 15, 3);
        add_action('bdp_author_detail', 'bdp_display_author_biography', 20, 2);
        add_action('bdp_author_detail', 'bdp_display_author_social_links', 25, 4);
        add_action('bdp_author_detail', 'bdp_display_author_content_cover_end', 30, 2);
        add_action('bdp_related_post_detail', 'bdp_related_post_title', 5, 4);
        add_action('bdp_related_post_detail', 'bdp_related_post_item', 10, 9);
    }

}